from cmu_graphics import *

# Thanks to a 112 TA (Shawn) and to a 112 student for their work on this,
# as well as the CS Academy dev team!

import os, pathlib

def loadSound(relativePath):
    url = pathlib.Path(os.path.abspath(relativePath)).as_uri()
    return Sound(url)

def onAppStart(app):
    app.sound1 = loadSound('sounds/bulletSound.mp3')
    app.sound2 = loadSound('sounds/roundStart.mp3')
    app.music = loadSound('sounds/themeSong.mp3')
    app.playing = False
    
def redrawAll(app):
    drawLabel('Sound Demo', app.width/2, app.height/2 - 40, size=30)
    drawLabel('Press space to play sound', app.width/2, app.height/2)
    drawLabel('Press s to play jingle', app.width/2, app.height/2 + 20)
    drawLabel(f'Press m to {"pause" if app.playing else "play"} music',
              app.width/2, app.height/2 + 40)
    
def onKeyPress(app, key):
    if key == 'space':
        app.sound1.play(restart=True) # lets you restart at any time
    elif key == 's':
        app.sound2.play()             # here the sound will play entirely
    elif key == 'm':
        if app.playing:
            app.music.pause()
            app.playing = False
        else:
            app.music.play(loop=True)
            app.playing = True

def main():
    runApp()
    
main()