from cmu_graphics import *
from PIL import Image

def onAppStart(app):
    app.sprites = loadAnimatedGif(app, 'sample-animatedGif.gif')
    app.spriteCounter = 0
    app.stepsPerSecond = 8

def loadAnimatedGif(app, path):
    pilImages = Image.open(path)
    if pilImages.format != 'GIF':
        raise Exception(f'{path} is not an animated image!')
    if not pilImages.is_animated:
        raise Exception(f'{path} is not an animated image!')
    cmuImages = [ ]
    for frame in range(pilImages.n_frames):
        pilImages.seek(frame)
        pilImage = pilImages.copy()
        cmuImages.append(CMUImage(pilImage))
    return cmuImages

def onStep(app):
    app.spriteCounter = (1 + app.spriteCounter) % len(app.sprites)

def onKeyPress(app, key):
    if key in ['up', 'right']:
        app.stepsPerSecond += 1
    elif key in ['down', 'left'] and app.stepsPerSecond > 1:
        app.stepsPerSecond -= 1

def redrawAll(app):
    # Draw the instructions and speed
    drawLabel('Use arrows to change speed', 200, 30, size=16)
    drawLabel(f'Current steps/second: {app.stepsPerSecond}', 200, 50)

    # Draw the current sprite image:
    sprite = app.sprites[app.spriteCounter]
    drawImage(sprite, 200, 200, align='center')

def main():
    runApp(400, 400)

if __name__ == '__main__':
    main()