from cmu_graphics import *
from PIL import Image, ImageDraw
import random

# For more on ImageDraw, see:
# https://pillow.readthedocs.io/en/stable/reference/ImageDraw.html

def onAppStart(app):
    # Make a new blank image with a cyan background
    cyan = (0, 255, 255)
    app.imageWidth = app.width//2
    app.imageHeight = app.height//2
    app.image = Image.new('RGB', (app.imageWidth, app.imageHeight), cyan)

    # Convert the PIL image to a CMUImage for drawing
    app.image = CMUImage(app.image)

def onKeyPress(app, key):
    # Get the PIL image from the CMUImage
    pilImage = app.image.image

    # Create the ImageDraw object
    app.draw = ImageDraw.Draw(pilImage)

    # Draw a random oval with random radii in a random color
    cx = random.randrange(app.imageWidth)
    cy = random.randrange(app.imageHeight)
    xr = random.randrange(5, 30)
    yr = random.randrange(5, 30)
    rgb = (random.randrange(256), random.randrange(256), random.randrange(256))
    app.draw.ellipse((cx-xr, cy-yr, cx+xr, cy+yr), fill=rgb)

    # Store the updated CMUImage
    app.image = CMUImage(pilImage)

def redrawAll(app):
    drawLabel('Original', 200, 125, align='center', size=24)
    drawImage(app.image, 200, 300, align='center')
    drawLabel('Scaled', 500, 125, align='center', size=24)
    pilImage = app.image.image
    drawImage(app.image, 500, 300, align='center',
              width=pilImage.width//2,
              height=pilImage.height//2)
    drawLabel('Press any key (repeatedly) to get random ovals',
              app.width//2, 50, size=24)

def main():
    runApp(600, 500)

if __name__ == '__main__':
    main()