from cmu_graphics import *
from PIL import Image

def onAppStart(app):
    app.image = Image.open('greatPitch.gif')
    app.redImage = makeRedImage(app.image)

    # Convert each PIL image to a CMUImage for drawing
    app.image = CMUImage(app.image)
    app.redImage = CMUImage(app.redImage)

def makeRedImage(sourceImage):
    # First, get the RGB version of the image so getpixel returns r,g,b values:
    rgbImage = sourceImage.convert('RGB')

    # Now, a new image in the 'RGB' mode with same dimensions as app.image
    newImage = Image.new(mode='RGB', size=rgbImage.size)
    for x in range(newImage.width):
        for y in range(newImage.height):
            r,g,b = rgbImage.getpixel((x,y))
            newImage.putpixel((x,y),(r,0,0)) # ignore green and blue!

    return newImage

def redrawAll(app):
    drawLabel('Original', 200, 50, align='center', size=24)
    drawImage(app.image, 200, 300, align='center')
    drawLabel('Red copy', 500, 50, align='center', size=24)
    drawImage(app.redImage, 500, 300, align='center')

def main():
    runApp(700, 550)

if __name__ == '__main__':
    main()