/*
	File:			Vec2.cc

	Function:		See header file

	Author(s):		Andrew Willmott

	Copyright:		Copyright (c) 1995-1996, Andrew Willmott

	Notes:			

	Change History:
		31/01/96	ajw		Started
*/

#include "Vec2.h"
#include <math.h>
#include <ctype.h>

#include <iomanip.h>


TMPLVec Bool TVec2::operator == (const TVec2 &a) const
{
	return(elt[0] == a[0] && elt[1] == a[1]);
}

TMPLVec Bool TVec2::operator != (const TVec2 &a) const
{
	return(elt[0] != a[0] || elt[1] != a[1]);
}


TMPLVec TReal len(const TVec2 &v)
{
	return(sqrt(v dot v));
}

TMPLVec TReal sqrlen(const TVec2 &v)
{
	return(v dot v);
}

TMPLVec TVec2 norm(const TVec2 &v)	
{
	return(v / len(v));
}


TMPLVec ostream &operator << (ostream &s, const TVec2 &v)
{
	Int w = s.width();

	return(s << '[' << v[0] << ' ' << setw(w) << v[1] << ']');
}

TMPLVec istream &operator >> (istream &s, TVec2 &v)
{
    TVec2	result;
    Char	c;
	
	// Expected format: [1 2]
	
    while (s >> c && isspace(c))		
		;
		
    if (c == '[')						
    {
		s >> result[0] >> result[1];	

		if (!s)
		{
			cerr << "Error: Expected number while reading vector\n";
			return(s);
		}
			
		while (s >> c && isspace(c))
			;
			
		if (c != ']')
    	{
    		s.clear(ios::failbit);
	    	cerr << "Error: Expected ']' while reading vector\n";
	    	return(s);
    	}
	}
    else
	{
	    s.clear(ios::failbit);
	    cerr << "Error: Expected '[' while reading vector\n";
	    return(s);
	}
	
	v = result;
    return(s);
}

