/*
	File:			SGMat.cc

	Function:		See header file

	Author(s):		Andrew Willmott

	Copyright:		Copyright (c) 1995-1996, Andrew Willmott

	Notes:			

	Change History:
		31/01/96	ajw		Started
*/

#include "SGMat.h"
#include "Mat.h"
#include "CopyMat.h"


#pragma mark -
// --- SGMat Constructors & Destructors ---------------------------------------


TMPLMat TSGMat::SGMat(Int m, Int n, Int span, TMReal data[]) :
		rows(m), cols(n),
		span(span), data(data)
{
}

TMPLMat TSGMat::SGMat(const TSGMat &m) :
		rows(m.rows), cols(m.cols),
		span(m.span), data(m.data)
{
}

#pragma mark -
// --- SGMat Assignment Operators ---------------------------------------------


TMPLMat TSGMat &TSGMat::operator = (const TSGMat &m)
{	
    return(CopyMat(SELF, m));
}
	  
TMPLMat TSGMat &TSGMat::operator = (const TMat &m)
{
    return(CopyMat(SELF, m));
}

TMPLMat TSGMat &TSGMat::operator >> (Action<TMReal> &a)
{
	Int i, j;
	
	a.Start();
	
	for (i = 0; i < rows; i++)
		for (j = 0; j < cols; j++)
			a.Process(elt(i, j));

	a.Stop();

	return(SELF);
}
