/*
	File:			Mat2.cc

	Function:		See header file

	Author(s):		Andrew Willmott

	Copyright:		Copyright (c) 1995-1996, Andrew Willmott

	Notes:			

*/

#include "Mat2.h"
#include <math.h>
#include <ctype.h>
#include <iomanip.h>


TMPLMat Bool TMat2::operator == (const TMat2 &m) const
{
	return(row[0] == m[0] && row[1] == m[1]);
}

TMPLMat Bool TMat2::operator != (const TMat2 &m) const
{
	return(row[0] != m[0] || row[1] != m[1]);
}


TMPLMat TMReal det(const TMat2 &m)
{
	return(m[0] dot cross(m[1]));
}

TMPLMat TMat2 inv(const TMat2 &m)
{
	TMReal			mDet;
	TMat2			result;
	
	result[0][0] =  m[1][1]; result[0][1] = -m[0][1]; 
	result[1][0] = -m[1][0]; result[1][1] =  m[0][0]; 
	
	mDet = m[0][0] * result[0][0] + m[0][1] * result[1][0];
	
	Assert(mDet != 0, "(Mat2::inv) matrix is non-singular");

	result /= mDet;
	
	return(result);
}


TMPLMat ostream &operator << (ostream &s, const TMat2 &m)
{
	Int w = s.width();

	return(s << '[' << m[0] << endl << setw(w) << m[1] << ']' << endl);
}

TMPLMat istream &operator >> (istream &s, TMat2 &m)
{
    TMat2	result;
    Char	c;
	
	// Expected format: [[1 2] [3 4]]
	// Each vector is a row of the row matrix.
	
    while (s >> c && isspace(c))		// ignore leading white space
		;
		
    if (c == '[')			
    {
		s >> result[0] >> result[1];

		if (!s)
		{
			cerr << "Expected number while reading matrix\n";
			return(s);
		}
			
		while (s >> c && isspace(c))
			;
			
		if (c != ']')
    	{
    		s.clear(ios::failbit);
	    	cerr << "Expected ']' while reading matrix\n";
	    	return(s);
    	}
	}
    else
	{
	    s.clear(ios::failbit);
	    cerr << "Expected '[' while reading matrix\n";
	    return(s);
	}
	
	m = result;
    return(s);
}


TMPLMat void TMat2::MakeRot(Real theta)  
{
	TMReal	c, s;
	
	s = sin(theta);
	c = cos(theta);
	
#ifdef ROW_ORIENT
	row[0][0] =  c; row[0][1] = s;
	row[1][0] = -s; row[1][1] = c;
#endif
}

TMPLMat void TMat2::MakeScale(const TVec2 &s)	
{		
	row[0][0] = s[0]; row[0][1] = 0;
	row[1][0] = 0   ; row[1][1] = s[1];
}

