/*
	File:			Basics.cc

	Function:		See header file

	Author(s):		Andrew Willmott

	Copyright:		Copyright (c) 1995-1996, Andrew Willmott

	Notes:			

	Change History:
		31/01/96	ajw		Started
*/

#include "Basics.h"
#include <stdio.h>
#include <stdlib.h>
#include <iostream.h>

#if defined(__MWERKS__) && defined(VL_DEBUG_NEW)
#include "DebugWrap.h"		// Debugging for new calls.	
#endif


#pragma mark -
// --- Error functions for range and routine checking -------------------------


ostream &operator << (ostream &s, Bool &b)
{
	if (b)
		s << "true";
	else
		s << "false";

	return(s);
}


#if defined(__MWERKS__) && defined(VL_DEBUG_NEW)
#include "DebugWrap.h"
#endif

void _Assert(Int condition, char *errorMessage, Char *file, Int line)
{
	if (!condition)
	{
		char reply;
		
		cerr << "\n*** Assert failed (line " << line << " in " << file << "): " << errorMessage << endl;
		cerr << "    Continue? [y/n] ";
		cin >> reply;
		
		if (reply != 'y')
		{
#if defined(__MWERKS__) && defined(VL_DEBUG_NEW)
		if (gHaveDebugger)
		{
			ToDebugger("Assert failed: ", errorMessage);
			return;
		}
#endif
			*((long *) 0) = 0; // Force a core dump/debugger break
			exit(1);
		}
	}
}

void _Expect(Int condition, char *warningMessage, Char *file, Int line)
{
	if (!condition)
		cerr << "\n*** Warning (line " << line << " in " << file << "): " << warningMessage << endl;
}

void _CheckRange(Int i, Int lowerBound, Int upperBound, char *rangeMessage, Char *file, Int line)
{
	if (i < lowerBound || i >= upperBound)
	{
		char reply;
		
		cerr << "\n*** Range Error (line " << line << " in " << file << "): " << rangeMessage << endl;	
		cerr << "    Continue? [y/n] ";
		cin >> reply;
		
		if (reply != 'y')
		{
			*((long *) 0) = 0;
			exit(1);
		}
	}
}
