/*
	File:			VLf.h

	Function:		Master header for a version of the VL library based on floats.
					The various classes are named Vecf, Mat3f, SparseVecf, etc.
					If VL_TEMPLATE is defined, link with -lVL, if not, use -lVLf.
					
	Author(s):		Andrew Willmott

	Copyright:		Copyright (c) 1995-1996, Andrew Willmott
 */

#ifndef __VLf__
#define __VLf__

#ifndef VL_TEMPLATE
#define VL_FLOAT
#endif

#include "Vec2.h"
#include "Mat2.h"
#include "Vec3.h"
#include "Mat3.h"
#include "Vec4.h"
#include "Mat4.h"

#include "Vec.h"
#include "Mat.h"

//#include "SparseVec.h"
//#include "SparseMat.h"

// --- Generate prototypes ----

#ifdef VL_TEMPLATE
#define PVReal float
#include "Proto.h"
#endif

// --- Generate suffixed type names ---

#ifdef VL_TEMPLATE
#define VL_V_PROTO(TYPE) typedef TYPE  <float> TYPE ## f
#define VL_M_PROTO(TYPE) typedef TYPE  <float, float> TYPE ## f
#else
#define VL_V_PROTO(TYPE) typedef TYPE  TYPE ## f
#define VL_M_PROTO(TYPE) typedef TYPE  TYPE ## f
#endif

#include "SuffProto.h"

#endif
