/*
	File:			VLd.h

	Function:		Master header for a version of the VL library based on doubles.
					The various classes are named Vecd, Mat3d, SparseVecd, etc.
					If VL_TEMPLATE is defined, link with -lVL, if not, use -lVLd.
					
	Author(s):		Andrew Willmott

	Copyright:		Copyright (c) 1995-1996, Andrew Willmott
 */


#ifndef __VLd__
#define __VLd__

#include "Vec2.h"
#include "Mat2.h"
#include "Vec3.h"
#include "Mat3.h"
#include "Vec4.h"
#include "Mat4.h"

#include "Vec.h"
#include "Mat.h"

//#include "SparseVec.h"
//#include "SparseMat.h"

// --- Generate prototypes ----

#ifdef VL_TEMPLATE
#define PVReal double
#include "Proto.h"
#endif

// --- Generate suffixed type names ---

#ifdef VL_TEMPLATE
#define VL_V_PROTO(TYPE) typedef TYPE  <double> TYPE ## d
#define VL_M_PROTO(TYPE) typedef TYPE  <double, double> TYPE ## d
#else
#define VL_V_PROTO(TYPE) typedef TYPE  TYPE ## d
#define VL_M_PROTO(TYPE) typedef TYPE  TYPE ## d
#endif

#include "SuffProto.h"

#endif
