/*
	File:			VL.h

	Function:		Header file for the VL library. Provides macro definitions
					so that the library can be used either in its templated or
					its normal form.
					
	Author(s):		Andrew Willmott

	Copyright:		Copyright (c) 1995-1996, Andrew Willmott
 */

#ifndef __VL__
#define __VL__


#include <stdio.h>
#include <iostream.h>
#include "Basics.h"

//
//	VL_TEMPLATE		- Template the vector library on container type  
//             		  Otherwise, vector and matrix types are dependent on
//					  the flags VL_MIXED and VL_FLOAT.
//
//	VL_BODY_TMPL	- Some compilers (e.g. CC/CFront) can handle having templates
//					  defined in the .cc file rather than the .h file. Define
//					  this if you have such a compiler.
//


//
//	A little of that #define magic which ensures that, while there may be 
//	x2c translators, there'll never be a c2x translator.
//

#undef CODE_IN_BODY		// Defines whether the VecN/MatN code belongs 
						// in the .cc file
#ifdef  VL_TEMPLATE 
#ifdef  VL_BODY_TMPL
#define CODE_IN_BODY 1
#else
#define CODE_IN_BODY 0
#endif
#else
#define CODE_IN_BODY 1
#endif


// --- On with the show... --------------------


enum Axis { x, y, z, w };

#ifdef VL_TEMPLATE

#define TMPLVec template<class TReal>
#define TMPLMat template<class TMReal, class TReal>

#define TVec2 Vec2<TReal>
#define TMat2  Mat2<TMReal, TReal>
#define TMVec2 Vec2<TMReal>

#define TVec3 Vec3<TReal>
#define TMat3  Mat3<TMReal, TReal>
#define TVMat3 Mat3<TReal,TReal> 		// Used internally by Vec4::det()
#define TMVec3 Vec3<TMReal>

#define TVec4 Vec4<TReal>
#define TMat4  Mat4<TMReal, TReal>
#define TMVec4 Vec4<TMReal>

#define TRM <TMReal, TReal>
#define TRV <TReal>

#define TVec Vec<TReal>
#define TSGVec SGVec<TReal>
#define TMSGVec SGVec<TMReal>
#define TMat Mat<TMReal, TReal>
#define TMVec Vec<TMReal>
#define TMMat Mat<TMReal, TMReal>
#define TSGMat SGMat<TMReal, TReal>

#define TSparseVec SparseVec<TReal>
#define TMSparseVec SparseVec<TMReal>
#define TSparseMat SparseMat<TMReal, TReal>
#define TMSparseMat SparseMat<TMReal, TMReal>
#define TSGSVec SGSVec<TReal>
#define TMSGSVec SGSVec<TMReal>
#define TSGSMat SGSMat<TMReal, TReal>

#define TSparsePair SparsePair<TReal>
#define TSVIter SVIter<TReal>

#else

#define TReal Real
#define TMReal Real

#define TMPLVec 
#define TMPLMat 

#define TVec2 Vec2
#define TMat2 Mat2
#define TMVec2 Vec2

#define TVec3 Vec3
#define TMat3 Mat3
#define TVMat3 Mat3		 		// Used internally by Vec4::det()
#define TMVec3 Vec3

#define TVec4 Vec4
#define TMat4 Mat4
#define TMVec4 Vec4

#define TRV
#define TRM

#define TVec Vec
#define TSGVec SGVec
#define TMSGVec SGVec
#define TMat Mat
#define TMVec Vec
#define TMMat Mat
#define TSGMat SGMat

#define TSparseVec SparseVec
#define TMSparseVec SparseVec
#define TSparseMat SparseMat
#define TMSparseMat SparseMat
#define TSGSVec SGSVec
#define TSGSMat SGSMat
#define TMSGSVec SGSVec

#define TSparsePair SparsePair
#define TSVIter SVIter

#endif

#endif	
