/*
	File:			Solve.h

	Function:		Defines routines for solving a system of linear equations: Ax = b etc.
					
	Author(s):		Andrew Willmott

	Copyright:		Copyright (c) 1995-1996, Andrew Willmott
 */

#ifndef __Solve__
#define __Solve__

#include "Basics.h"
#include "Action.h"

template <class T> class Clean : public Action<T>
{
public:
	void Process(T &t);	// override
};

template <class Matrix>
	Matrix &defuzz(Matrix &m, Real fuzz);

template <class Matrix>
	Matrix &defuzz(Matrix &m);

template <class TMatrix>
	TMatrix inverse(const TMatrix &m);	

template <class Matrix, class Vector, class Elt>
	Elt SolveOverRelax(const Matrix &a, const Vector &b, Vector &x,
				Elt omega);

template <class Matrix, class Vector, class Real>
	Real SolveConjGrad(const Matrix &a, const Vector &b, Vector &x,
			Real tolerance, Int &step);

#ifdef VL_TEMPLATE
#include "Solve.cc"
#endif

#endif

