/*
	File:			SGVec.h

	Function:		Defines a scatter-gather vector, i.e., a subvector of another vector, 
					or the row, column or diagonal of a matrix.
					
	Author(s):		Andrew Willmott

	Copyright:		Copyright (c) 1995-1996, Andrew Willmott
 */

#ifndef __SGVec__
#define __SGVec__

#include "VL.h"
#include "Action.h"

TMPLVec class Vec;
 
TMPLVec class SGVec
{
public:

					SGVec(Int n, TReal data[], Int span);
					SGVec(TSGVec &v);
	
	inline Int		Elts() const;

	inline TReal	&operator () (Int i);		    		// v(1) - Indexing
	inline TReal	operator () (Int i) const;		  

	inline TReal	&operator [] (Int i);		    		// v[1] - Has no index 
	inline TReal	operator [] (Int i) const;				//        check			  

	TSGVec			&operator = (const TSGVec &v);
	TSGVec			&operator = (const TVec &v);

	TSGVec 			&operator >> (Action<TReal> &a);

protected:
	
	Int		elts;
	Int		span;
	TReal	*data; 
};


// --- SGVec inlines ---------------------------------------------------


TMPLVec inline Int TSGVec::Elts() const
{
	return(elts);
}

TMPLVec inline TReal &TSGVec::operator () (Int i)
{
	CheckRange(i, 0, elts, "Vec::(i)");
	
    return(data[i * span]);
}

TMPLVec inline TReal TSGVec::operator () (Int i) const
{
	CheckRange(i, 0, elts, "Vec::(i)");
	
    return(data[i * span]);
}

TMPLVec inline TReal &TSGVec::operator [] (Int i)
{
	CheckRange(i, 0, elts, "Vec::[i]");
	
    return(data[i * span]);
}

TMPLVec inline TReal TSGVec::operator [] (Int i) const
{
	CheckRange(i, 0, elts, "Vec::[i]");

    return(data[i * span]);
}


#ifdef VL_TEMPLATE
#include "SGVec.cc"
#endif

#endif
