/*
	File:			CopyMat.h

	Function:		Template for copying between different matrix types.
					
	Author(s):		Andrew Willmott

	Copyright:		Copyright (c) 1995-1996, Andrew Willmott
 */



#ifndef __CopyMat__
#define __CopyMat__

template<class TA, class TB> TA &CopyMat(TA &m, const TB &n)
{
	Int		i, j;
	
	Assert(m.Rows() == n.Rows(), "(CopyMat::=) Matrix rows don't match");
	Assert(m.Cols() == n.Cols(), "(CopyMat::=) Matrix columns don't match");

	for (i = 0; i < m.Rows(); i++) 
		for (j = 0; j < m.Cols(); j++)
			m[i][j] = n[i][j];
		
	return(m);
}

template<class TA, class TB> TA &NCCopyMat(TA &m, TB &n)
{
	Int		i, j;
	
	Assert(m.Rows() == n.Rows(), "(CopyMat::=) Matrix rows don't match");
	Assert(m.Cols() == n.Cols(), "(CopyMat::=) Matrix columns don't match");

	for (i = 0; i < m.Rows(); i++) 
		for (j = 0; j < m.Cols(); j++)
			m[i][j] = n[i][j];
		
	return(m);
}

#endif


