#include "illum.H"

class Phong : public Illum {	// Phong illumination model
  public:
    Phong();

    // Phong model has 6 parameters
    // they can be accessed generically using param[i].val, or in a
    // more readable way via:

    Param &kdp() const {return param[0];}   // coeff of diffuse reflection
    Param &ksp() const {return param[1];}   // coeff of specular reflection
    Param &exponp() const {return param[2];}// exponent (related to roughness)
    Param &mat_rp() const {return param[3];}// diffuse refl at red wavelength
    Param &mat_gp() const {return param[4];}// diffuse refl at green wavelength
    Param &mat_bp() const {return param[5];}// diffuse refl at blue wavelength

	// mat_r,g,b get multiplied by kd, so there are actually just 3 degrees
	// of freedom between the four of them

    double &kd() const {return kdp().val;}
    double &ks() const {return ksp().val;}
    double &expon() const {return exponp().val;}
    double &mat_r() const {return mat_rp().val;}
    double &mat_g() const {return mat_gp().val;}
    double &mat_b() const {return mat_bp().val;}

    void reset();

    Vec3 brdf(const Vec3 &n, const Vec3 &l, const Vec3 &v) const;

    void print(ostream &s) const;	// print current settings
};
