/*
	File:		heBRDF.H
	
	Function:	Header for a C implementation of the He-Torrance reflection model
				
	Author(s):	Andrew Willmott	(ajw+@cs.cmu.edu)
				Based on original mathematica & .cal code from Greg Ward
*/


#ifndef __He__
#define __He__

#include "illum.H"

class HeBRDF : public Illum
{
public:
	HeBRDF();

	static Real 	lambda;		// wavelenth (microns)
	static Real		epsilon;	// fuzz factor

	//	Overrides

    void			reset();        // reset parameters to default values
    Vec3			brdf(const Vec3 &n, const Vec3 &i, const Vec3 &o) const;
    void			print(ostream &s) const;        // print current settings

	//	Parameters
	
	Real			nr() const		// Index of refraction, real component
	{ return(param[0].val); };
	Real			ni() const		// Index of refraction, imag. component
	{ return(param[1].val); };
	Real			tau() const		// correlation distance (microns)
	{ return(param[2].val); };
	Real			sigma0() const	// surface height deviation (microns)
	{ return(param[3].val); };
	Real			diffuse() const	// scale for UD component;	
	{ return(param[4].val); };

	//	Internal functions

	Real			shadowf(Real t);
	Real			kK(Real t);
	Real			gFunc(Real ti, Real tr);
	Real			kD(const Vec3 &ki, const Vec3 &kr, const Vec3 &ns);
	Real			kG(const Vec3 &ki, const Vec3 &kr, const Vec3 &ns);
	Real			z0d(Real Ki, Real z);
	Real			z0lim(Real x);
	Real			z0off(Real Ki, Real z);
	Real			z0rootf(Real Ki, Real x0, Real x1, Int i);
	Real			z0root(Real ti, Real tr);
	Real			sigma(Real ti, Real tr);

	Real			rhoSp(const Vec3 &ki, const Vec3 &kr, const Vec3 &ns);
	Real			rhoDD(const Vec3 &ki, const Vec3 &kr, const Vec3 &ns);
	Real			rhoUD(const Vec3 &ki, const Vec3 &kr, const Vec3 &ns);
};

typedef HeBRDF HTSG;

#endif
