;;; Section 3.4   S T R E A M S   page 242 ff.

;;; at first, streams are implemented as ordinary lists

;;; the following variables create the representation for streams

(define cons-stream cons)
(define head car)
(define tail cdr)
(define empty-stream? null?)
(define the-empty-stream ())

;;; the following variables are abstract operators on streams, independent
;;; of the representation above (I hope :-)

(define (append-streams s1 s2)
  (cond
   (  (empty-stream? s1)  s2  )
   (  t  (cons-stream (head s1) (append-streams (tail s1) s2)))))

(define (accumulate combiner initial-value stream)
  (cond
   (  (empty-stream? stream)  initial-value  )
   (  t  (combiner 
          (head stream)
          (accumulate combiner initial-value (tail stream)))  )))

(define (flatten stream)
  (accumulate append-streams the-empty-stream stream))

(define (horner-eval x coeff-stream)
  (define (add-term coeff higher-terms)
    (+ coeff (* x higher-terms)))
  (accumulate add-term 0 coeff-stream))

(define (map-stream proc stream)
  (cond
   (  (empty-stream? stream)  the-empty-stream  )
   (  t  (cons-stream
          (proc (head stream))
          (map-stream proc (tail stream)))  )))

(define (filter-stream predicate? stream)
  (cond
   (  (empty-stream? stream)  the-empty-stream  )
   (  (predicate? (head stream))
        (cons-stream 
         (head stream) 
         (filter-stream predicate? (tail stream)))  )
   (  t  (filter-stream predicate? (tail stream))  )))

(define (for-each-stream proc stream)  ;; NO OUTPUT; FOR SIDE-EFFECTS ONLY
  (cond
   (  (empty-stream? stream)  'done  )
   (  t  (begin
          (proc (head stream))
          (for-each-stream proc (tail stream)))  )))

(define (enumerate-interval low high)
  (if (> low high)
      the-empty-stream
      (cons-stream low (enumerate-interval (1+ low) high))))

;;; page 251, Ex. 3.38

(define (left-accumulate combiner initial-value stream)
  (cond
   (  (empty-stream? stream)  initial-value  )
   (  t  (left-accumulate combiner
                          (combiner initial-value (head stream))
                          (tail stream))  )))

;;; page 252, Ex. 3.39

(define (accumulate-n op init streams)  ;; CROSS-SECTION ACROSS
  (cond                                 ;; A STREAM OF STREAMS
   (  (empty-stream? (head streams))  the-empty-stream  )
   (  t  (cons-stream
          (accumulate
           op
           init
           (map-stream head streams))
          (accumulate-n
           op
           init
           (map-stream tail streams)))  )))

;;; page 253

(enumerate-interval 1 100)

(define (pairs-no-flatten n)
  (map-stream
   (lambda (i)
     (map-stream (lambda (j) (list i j))
                 (enumerate-interval 1 (-1+ i))))
   (enumerate-interval 1 n)))

(define (stream-of-pairs n)
  (flatten
   (map-stream
    (lambda (i)
      (map-stream (lambda (j) (list i j))
                  (enumerate-interval 1 (-1+ i))))
    (enumerate-interval 1 n))))

(define (flatmap f s) (flatten (map f s)))

;;; THE DEFINITION OF THE SPECIAL FORM "COLLECT", PAGE 256, AS A MACRO, IS
;;; A FAIRLY BIG JOB.  SOME OTHER TIME.

