(herald risc_apply (env tsys))

(define (apply-traced-operation proc . args)
  (lap (*traced-op-template*)
    (load l (d@r P (static *traced-op-template*)) parassign-extra)
    (load l (d@r parassign-extra 2) parassign-extra)
    (jbr entry)))

(define (apply proc . args)
 (lap ()                 
  (move zero parassign-extra)
entry
  (sub ($ 2) NARGS)                        ;; shift proc out
  (move A1 P)                         ;; first arg is proc
  (j= NARGS zero apply-done)
  (jn= NARGS ($ 1) next1)
  (move A2 AN)
  (jbr apply-one-arg)
next1
  (move A2 A1)
  (jn= NARGS ($ 2) next2)
  (move A3 AN)
  (jbr apply-two-args)
next2
  (move A3 A2)
  (jn= NARGS ($ 3) next3)
  (move A4 AN)                
  (jbr apply-three-args)
next3
  (move A4 A3)
  (jn= NARGS ($ 4) next4)
  (move A5 AN)                
  (jbr apply-four-args)
next4
  (move A5 A4)
  (jn= NARGS ($ 5) next5)
  (move A6 AN)                
  (jbr apply-five-args)
next5
  (move A6 A5)
  (jn= NARGS ($ 6) next6)
  (move A7 AN)                
  (jbr apply-six-args)
next6
  (move A7 A6)
  (jn= NARGS ($ 7) next7)
  (move A8 AN)                
  (jbr apply-seven-args)
next7
  (move A8 A7)
  (jn= NARGS ($ 8) next8)
  (move A9 AN)                
  (jbr apply-eight-args)
next8
  (move A9 A8)
  (jn= NARGS ($ 9) next9)
  (move A10 AN)                
  (jbr apply-nine-args)
next9
  (move A10 A9)
  (jn= NARGS ($ 10) next10)
  (move A11 AN)                
  (jbr apply-ten-args)
next10
  (move A11 A10)
  (jn= NARGS ($ 11) next11)
  (move A12 AN)                
  (jbr apply-eleven-args)
next11
  (move A12 A11)
  (jn= NARGS ($ 12) next12)
  (load l (d@r extra-args %%car) AN)                
  (jbr apply-twelve-args)
next12
  (move extra-args extra)	;save extra args
  (load l (d@r extra %%car) A12)            ;; first argument temp
  (sub ($ (+ *argument-registers* 1)) NARGS vector)             ;; S1 counts sown to 0
  (jbr apply-shift-test)
apply-shift-loop-top
  (sub ($ 1) vector)
  (load l (d@r extra %%cdr) extra)
apply-shift-test
  (jn= vector zero apply-shift-loop-top)
  (load l (d@r extra %%cdr) an)
  (load l (d@r an %%car) an)
  (store l an (d@r extra %%cdr))
count-list-test
  (j= an nil-reg apply-done)
  (load l (d@r an %%cdr) an)
  (add ($ 1) nargs)
  (jbr count-list-test)
apply-one-arg
  (j= AN nil-reg apply-done)
  (load l (d@r an %%car) A1)                    
  (add ($ 1) NARGS)
  (load l (d@r an %%cdr) AN)                   
apply-two-args
  (j= AN nil-reg apply-done)
  (load l (d@r an %%car) A2)                    
  (add ($ 1) NARGS)
  (load l (d@r an %%cdr) AN)                   
apply-three-args
  (j= AN nil-reg apply-done)
  (load l (d@r an %%car) A3)                    
  (add ($ 1) NARGS)
  (load l (d@r an %%cdr) AN)                   
apply-four-args
  (j= AN nil-reg apply-done)
  (load l (d@r an %%car) A4)                    
  (add ($ 1) NARGS)
  (load l (d@r an %%cdr) AN)                   
apply-five-args
  (j= AN nil-reg apply-done)
  (load l (d@r an %%car) A5)                    
  (add ($ 1) NARGS)
  (load l (d@r an %%cdr) AN)                   
apply-six-args
  (j= AN nil-reg apply-done)
  (load l (d@r an %%car) A6)                    
  (add ($ 1) NARGS)
  (load l (d@r an %%cdr) AN)                   
apply-seven-args
  (j= AN nil-reg apply-done)
  (load l (d@r an %%car) A7)                    
  (add ($ 1) NARGS)
  (load l (d@r an %%cdr) AN)                   
apply-eight-args
  (j= AN nil-reg apply-done)
  (load l (d@r an %%car) A8)                    
  (add ($ 1) NARGS)
  (load l (d@r an %%cdr) AN)                   
apply-nine-args
  (j= AN nil-reg apply-done)
  (load l (d@r an %%car) A9)                    
  (add ($ 1) NARGS)
  (load l (d@r an %%cdr) AN)                   
apply-ten-args
  (j= AN nil-reg apply-done)
  (load l (d@r an %%car) A10)                    
  (add ($ 1) NARGS)
  (load l (d@r an %%cdr) AN)                   
apply-eleven-args
  (j= AN nil-reg apply-done)
  (load l (d@r an %%car) A11)                    
  (add ($ 1) NARGS)
  (load l (d@r an %%cdr) AN)                   
apply-twelve-args
  (j= AN nil-reg apply-done)
  (load l (d@r an %%car) A12)                    
  (add ($ 1) NARGS)
  (load l (d@r an %%cdr) AN)                   
  (move an extra-args)
  (jbr count-list-test)
apply-done                    
  (jn= parassign-extra zero traced)
  (load l (d@r p -2) parassign-extra)
traced
  (add ($ 2) parassign-extra extra)
  (jr extra)
  (noop)))


(define (apply-init)
  (lap ()
    (movea %extra-args extra)
    (store l extra (d@nil slink/make-extra-args))
    (movea %nary-setup extra)
    (store l extra (d@nil slink/nary-setup))
    (jr link-reg)
    (move ($ -1) nargs)
%extra-args				;bytes in scratch
    (or ($ #b10000000) crit-reg)
    (load l (d@nil slink/area-frontier) extra)
    (add extra scratch)
    (load l (d@nil slink/area-limit) vector)
    (j> vector scratch %extra-args-heap-overflow)
    (store l scratch (d@nil slink/area-frontier))
    (add ($ 3) extra extra-args)
    (add ($ 11) extra)
extra-args-test
    (j> extra vector extra-args-done)
    (store l extra (d@r extra -11))
    (add ($ 8) extra)
    (jbr extra-args-test)
extra-args-done
    (store l nil-reg (d@r extra -11))
    (mask ($ #x7f) crit-reg)
    (jn= zero crit-reg %deferred-interrupts)
    (jr link-reg)
    (noop)
%extra-args-heap-overflow
    (store l t-reg (d@nil slink/doing-gc?))
    (sub extra scratch)
    (move link-reg extra)			;heap overflow moves it back
    (load l (d@nil slink/heap-overflow) link-reg)
    (jalr link-reg)
    (noop)
    (store l nil-reg (d@nil slink/doing-gc?))
    (jbr %extra-args)
  
%nary-setup                                 ; required args in vector
  (sub ($ 1) NARGS)
  (sub vector nargs parassign-extra)
  (j= parassign-extra zero no-rest-args)
  (sll ($ 3) parassign-extra)			;bytes to cons
%nary-setup-continue                        ; lose, lose
  (or ($ #b10000000) crit-reg)
  (load l (d@nil slink/area-frontier) AN)
  (add an parassign-extra)
  (load l (d@nil slink/area-limit) extra)
  (j> extra parassign-extra %nary-make-pair-heap-overflow)
  (store l parassign-extra (d@nil slink/area-frontier))
  (add ($ 3) an)
  (add ($ 8) an extra)
  (j= vector zero move-a1)
  (j= vector ($ 1) move-a2)
  (j= vector ($ 2) move-a3)
  (j= vector ($ 3) move-a4)
  (j= vector ($ 4) move-a5)
  (j= vector ($ 5) move-a6)
  (j= vector ($ 6) move-a7)
  (j= vector ($ 7) move-a8)
  (j= vector ($ 8) move-a9)
  (j= vector ($ 9) move-a10)
  (j= vector ($ 10) move-a11)
  (j= vector ($ 11) move-a12)
many-loop
  (load l (d@r extra-args %%car) vector)
  (load l (d@r extra-args %%cdr) extra-args)
  (store l vector (d@r extra -7))
  (store l extra (d@r extra -11))
  (add ($ 8) extra)
  (add ($ 1) vector)
  (j< vector nargs many-loop)
  (jr link-reg)
  (store l extra-args (d@r extra -11))
move-a1
  (store l a1 (d@r extra -7))
  (store l extra (d@r extra -11))
  (add ($ 8) extra)
  (add ($ 1) vector)
  (j>= vector nargs registers-moved)
move-a2
  (store l a2 (d@r extra -7))
  (store l extra (d@r extra -11))
  (add ($ 8) extra)
  (add ($ 1) vector)
  (j>= vector nargs registers-moved)
move-a3
  (store l a3 (d@r extra -7))
  (store l extra (d@r extra -11))
  (add ($ 8) extra)
  (add ($ 1) vector)
  (j>= vector nargs registers-moved)
move-a4
  (store l a4 (d@r extra -7))
  (store l extra (d@r extra -11))
  (add ($ 8) extra)
  (add ($ 1) vector)
  (j>= vector nargs registers-moved)
move-a5
  (store l a5 (d@r extra -7))
  (store l extra (d@r extra -11))
  (add ($ 8) extra)
  (add ($ 1) vector)
  (j>= vector nargs registers-moved)
move-a6
  (store l a6 (d@r extra -7))
  (store l extra (d@r extra -11))
  (add ($ 8) extra)
  (add ($ 1) vector)
  (j>= vector nargs registers-moved)
move-a7
  (store l a7 (d@r extra -7))
  (store l extra (d@r extra -11))
  (add ($ 8) extra)
  (add ($ 1) vector)
  (j>= vector nargs registers-moved)
move-a8
  (store l a8 (d@r extra -7))
  (store l extra (d@r extra -11))
  (add ($ 8) extra)
  (add ($ 1) vector)
  (j>= vector nargs registers-moved)
move-a9
  (store l a9 (d@r extra -7))
  (store l extra (d@r extra -11))
  (add ($ 8) extra)
  (add ($ 1) vector)
  (j>= vector nargs registers-moved)
move-a10
  (store l a10 (d@r extra -7))
  (store l extra (d@r extra -11))
  (add ($ 8) extra)
  (add ($ 1) vector)
  (j>= vector nargs registers-moved)
move-a11
  (store l a11 (d@r extra -7))
  (store l extra (d@r extra -11))
  (add ($ 8) extra)
  (add ($ 1) vector)
  (j>= vector nargs registers-moved)
move-a12
  (store l a12 (d@r extra -7))
  (store l extra (d@r extra -11))
  (add ($ 8) extra)
  (add ($ 1) vector)
  (j>= vector nargs registers-moved)
  (jr link-reg)
  (store l extra-args (d@r extra -11))
registers-moved
  (jr link-reg)
  (store l nil-reg (d@r extra -11))
no-rest-args
  (jr link-reg)
  (move nil-reg an)
%nary-make-pair-heap-overflow
    (store l t-reg (d@nil slink/doing-gc?))
    (sub an vector)
    (move link-reg extra)			;heap overflow moves it back
    (load l (d@nil slink/heap-overflow) link-reg)
    (jalr link-reg)
    (noop)
    (store l nil-reg (d@nil slink/doing-gc?))
    (jbr %nary-setup-continue)))

(apply-init)