(herald mipscokernel (env tsys))

;;; Copyright (c) 1985 Yale University
;;;     Authors: N Adams, R Kelsey, D Kranz, J Philbin, J Rees.
;;; This material was developed by the T Project at the Yale University Computer 
;;; Science Department.  Permission to copy this software, to redistribute it, 
;;; and to use it for any purpose is granted, subject to the following restric-
;;; tions and understandings.
;;; 1. Any copy made of this software must include this copyright notice in full.
;;; 2. Users of this software agree to make their best efforts (a) to return
;;;    to the T Project at Yale any improvements or extensions that they make,
;;;    so that these may be included in future releases; and (b) to inform
;;;    the T Project of noteworthy uses of this software.
;;; 3. All materials developed as a consequence of the use of this software
;;;    shall duly acknowledge such use, in accordance with the usual standards
;;;    of acknowledging credit in academic research.
;;; 4. Yale has made no warrantee or representation that the operation of
;;;    this software will be error-free, and Yale is under no obligation to
;;;    provide any services, by way of maintenance, update, or otherwise.
;;; 5. In conjunction with products arising from the use of this material,
;;;    there shall be no use of the name of the Yale University nor of any
;;;    adaptation thereof in any advertising, promotional, or sales literature
;;;    without prior written consent from Yale in each case.
;;;

;;; The procedure big_bang MUST come first in this file.
;;; BIG_BANG is called to instantiate the root process of an external
;;; T image. It is called by a foreign stub program with arguments
;;; as follows:
;;;
;;;  (BIG_BANG memory mem-size argc argv bsd4.2?).
;;;
;;; The argument vector is saved as a T vector in *BOOT-ARGS*.  The
;;; Xenoids are created for STDIN and STDOUT and placed in the 2nd
;;; and 3rd argument registers.  The global-constant register (NIL)
;;; and the task register are initialized, and the root process
;;; block is created and initialized.  The stack is initialized.
;;; The heap-pointer and heap-limit of the root process are
;;; initialized.  Finally the address of the T procedure BOOT is
;;; placed in them P (procedure) register, and we jump through the
;;; root process block to ICALL.  Boot is called as follows:
;;;
;;;     (BOOT root-task boot-args),

;;; Unresolved issues:
;;; - Is the arg vector the right size and is the descriptor correct?
;;; - What should the initial stack size be and how can you tell?
;;; - The stack and areas should have guards - later I  guess
;;; - how to boot other systems
;;; - stdio shit?
;;; - PID as Fixnum?
;;; - *the-slink*
;;; - test stack-overflow in icall?
;;; - heap overflow code
;;; - exception code
;;; - interrupt code


;;;  When we enter Big_bang the stack looks as follows:
;;;
;;;              |      debug?   |
;;;              |_______________|
;;;              |      argv     |    Command line argv
;;;              |_______________|
;;;              |      argc     |    Command line argc
;;;              |_______________|
;;;              |  heap-size    |  
;;;              |_______________|
;;;              |     heap2     | 
;;;              |_______________|  
;;;              |     heap1     |
;;;              |_______________|
;;;       SP =>  |     dummy     |
;;;              |_______________|
;;;              |    header     |  <= *boot-args*
;;;              |_______________|

(define (big_bang)
  (lap (*boot* *the-slink* risc-big-bang)

    ;; set up global-constants
    (move zero crit-reg)
    (move ($ header/true) t-reg)
    (load l (d@r P (static *the-slink*)) extra)
    (load l (d@r extra 2) nil-reg)
    (sub ($ 3) nil-reg sp)		;grows down to data bottom 512K
    (sll ($ 2) scratch)
    (store l scratch (d@nil slink/interrupt-handler))    ; interrupt_xenoid

    (store l a2 (d@r ssp 0))		;heap1  a2=$4
    (store l a3 (d@r ssp 4))		;heap2
    (store l a4 (d@r ssp 8))		;heap-size
    (store l a5 (d@r ssp 12))		;argc
    (move SSP A1)  ; save argument pointer        
    (sub ($ 8) ssp)			;dummy,header
    (movec (fx+ (fixnum-ashl 6 8) header/general-vector) extra)
    (store l extra (d@r ssp 0))
    (add ($ 2) ssp a2)
    (store l A2 (d@nil slink/boot-args))    ; we have 6 boot-args

    (load l (d@r P (static risc-big-bang)) P)
    (load l (d@r p 2) p)
    (load l (d@r P -2) extra)
    (add ($ 2) extra)
    (jalr extra)
    (noop)
    ;; initialize area, area-frontier, and area-limit
    (load l  (d@r A1 0) scratch)                       ; move addr heap
    (store l scratch (d@nil slink/area-begin))      
    (store l scratch (d@nil slink/area-frontier))         
    (load l (d@r A1 8) vector)
    (add vector scratch)
    (store l scratch (d@nil slink/area-limit))

    ;; Set up the procedure register P and call boot,
    ;; never to return. (note: args 2 was setup above)
    (move nil-reg A3)
    (load l (d@r a1 20) extra)
    (j= extra zero %debug)
    (move t-reg A3)
%debug
    (store l zero (d@nil slink/saved-ssp))
    (load l (d@r P (static *boot*)) P)
    (load l (d@r p 2) p)
    (load l (d@r P -2) extra)
    (add ($ 2) extra)
    (jr extra)
    (move  ($ 4) NARGS)))                            


;;;; Low-level exception handling

;;; Interrupts can be deferred.   
;;; the task/critical count byte has
;;; bit 7 -- interrupts deferred
;;; bit 0 -- quit pending

(define (interrupt_dispatcher)       ; signal=a2,code=a3,context=a4
  (lap (signal-handler enable-signals gc-interrupt)
       
    (load l (d@r p (static *the-slink*)) nil-reg)
    (load l (d@r nil-reg 2) nil-reg)
    (load l (d@nil slink/doing-gc?) extra)
    (jn= extra nil-reg %doing-gc)    ; are we doing gc?
    (load l (d@nil slink/saved-ssp) a1)
    (jn= a1 zero %foreign)
    (jn= a2 ($ 2) %fault)                   ; is this a ^c?
    (mask ($ 1) crit-reg scratch)	; is this the second one?                
    (j= scratch  zero %set-interrupt-flag) ; if not, defer interrupt
    (mask ($ #xfe) crit-reg)		;turn off bit 0
    (j= crit-reg zero %fault)		; are interrupts deferred?
%set-interrupt-flag    
    (or ($ 1) crit-reg)			; set quit bit
    (store l crit-reg (d@r a4 (* 24 4))) ;crit-reg = r21 +pc,mask,onstack    
%ignore-interrupt 
    (load l (d@r p (static enable-signals)) p)    ; DON'T CONS!!!
    (load l (d@r p 2) p)
    (load l (d@r p -2) extra)
    (add ($ 2) extra)
    (jr extra)
    (noop)
%doing-gc
    (load l (d@r p (static gc-interrupt)) p)    ; DON'T CONS!!!
    (load l (d@r p 2) p)
    (load l (d@r p -2) extra)
    (add ($ 2) extra)
    (jr extra)
    (noop)

;;; Interrupts should be disabled here.
%foreign
    (move ($ header/true) t-reg)
    (load l (d@nil slink/saved-crit) crit-reg)
					;saved ssp in a1
    ;; Interrupted out of foreign code.
    (load l (d@nil slink/saved-sp) sp)	;restore T stack pointer
    (store l zero (d@nil slink/saved-ssp))
    (sub ($ 12) sp)
    (load l (d@r a1 -4) extra)		;saved link reg at original -4(ssp)
    (store l extra (d@r sp 8))
    (store l a1 (d@r sp 4))		;save orignal ssp
    (store l link-reg (d@r sp 0))	;save fault ra
    (sll ($ 2) a2)			;signal number
    (move zero a3)
    (move zero a4)
    (move zero a5)
    (move zero a6)
    (move zero a7)
    (move zero a8)
    (move zero a9)
    (move zero a10)
    (move zero a11)
    (move zero an)
    (move zero an+1)
    (move zero parassign-extra)
    (move zero extra)
    (load l  (d@r p (static signal-handler)) p)
    (load l (d@r p 2) p)
    (load l (d@r p -2) extra)
    (add ($ 2) extra)
    (move ($ 3) nargs)
    (jalr extra)
    (add ($ 12) link-reg)
    (template 2 -1 t)
    (load l (d@r sp 4) scratch)
    (store l scratch (d@nil slink/saved-ssp))
    (load l (d@r sp 0) link-reg)
    (jr link-reg)
    (add ($ 12) sp)
%fault
    (sub ($ 8) sp)			;retore if we throw out
    (load l (d@r a4 (* 34 4)) extra)	;link-reg = r31 +pc,mask,onstack
    (store l extra (d@r sp 4))		;describe top of stack
    (store l link-reg (d@r sp 0))	;save ra of fault handler
    (load l (d@r a4 (* 32 4)) a1)	;ssp = r29 +pc,mask,onstack
    (sll ($ 2) a2)			;signal number
    (load l  (d@r p (static signal-handler)) p)
    (load l (d@r p 2) p)
    (load l (d@r p -2) extra)
    (add ($ 2) extra)
    (move ($ 3) nargs)
    (jalr extra)
    (add ($ 12) link-reg)
    (template 1 -1 t)
    (load l (d@r sp 0) link-reg)
    (jr link-reg)
    (add ($ 8) sp)))


(define local-processor
  (lambda ()
    (object nil
      ((processor-type self)     'mips)
      ((print-type-string self)  "Processor"))))

(define (local-machine)
  (object nil                               
      ((machine-type self)          'mipsco)
      ((machine-suspend-file self) '(link mipscosuspend))
      ((object-file-type self)      'mbo)
      ((information-file-type self) 'mbi)
      ((noise-file-type self)       'mbn)
      ((print-type-string self)     "Machine")))

(define (nan? x) (ignore x) '#f)

(define (st_mtime stat-block)
  (+ (ash (mref-16-u stat-block 28) 16) 
     (mref-16-u stat-block 30)))

(define-integrable (st_size stat-block)
  (mref-integer stat-block 20))


(define-integrable (st_mode stat-block)
  (mref-16-u stat-block 8))


(define-constant %%apollo-d-ieee-size 53)
(define-constant %%apollo-d-ieee-excess 1023)

;;; <n,s> means bit field of length s beginning at bit n of the first
;;; WORD (not longword)
;;;                    sign      exponent   MSB       fraction
;;; IEEE flonum        <15,1>    <4,11>     hidden    <0,4>+next 3 words
;;; VAX11 flonum (D)   <15,1>    <7,8>      hidden    <0,7>+next 3 words

(define (integer-decode-float x)     ; IEEE version
  (let ((a (mref-16-u x 0)))
    (return (if (fl<= 0.0 x) 1 -1)
            (+ (mref-16-u x 6)
               (%ash (+ (mref-16-u x 4)
                        (%ash (fx+ (mref-16-u x 2)
                                   (fixnum-ashl (fx+ (fixnum-bit-field a 0 4) 16)
                                                16))
                              16))
                     16))
            (fx- (fixnum-bit-field a 4 11) (fx+ 1024 51)))))

(define (integer-encode-float sign m e)
  (let ((float (make-flonum)))
    (receive (sign mantissa exponent)
             (normalize-float-parts sign
                                    m
                                    e
                                    %%apollo-d-ieee-size 
                                    %%apollo-d-ieee-excess 
                                    t)
      (set (mref-16-u float 0) (fx+ (fixnum-ashl sign 15)
                                    (fx+ (fixnum-ashl exponent 4)
                                         (bignum-bit-field mantissa 48 4))))
      (set (mref-16-u float 2) (bignum-bit-field mantissa 32 16)) 
      (set (mref-16-u float 4) (bignum-bit-field mantissa 16 16)) 
      (set (mref-16-u float 6) (bignum-bit-field mantissa 0  16)) 
      float)))

