(herald spprimops
        (env (*value orbit-env 'base-early-binding-env) constants))

;;; Copyright (c) 1985 Yale University
;;;     Authors: N Adams, R Kelsey, D Kranz, J Philbin, J Rees.
;;; This material was developed by the T Project at the Yale University Computer 
;;; Science Department.  Permission to copy this software, to redistribute it, 
;;; and to use it for any purpose is granted, subject to the following restric-
;;; tions and understandings.
;;; 1. Any copy made of this software must include this copyright notice in full.
;;; 2. Users of this software agree to make their best efforts (a) to return
;;;    to the T Project at Yale any improvements or extensions that they make,
;;;    so that these may be included in future releases; and (b) to inform
;;;    the T Project of noteworthy uses of this software.
;;; 3. All materials developed as a consequence of the use of this software
;;;    shall duly acknowledge such use, in accordance with the usual standards
;;;    of acknowledging credit in academic research.
;;; 4. Yale has made no warrantee or representation that the operation of
;;;    this software will be error-free, and Yale is under no obligation to
;;;    provide any services, by way of maintenance, update, or otherwise.
;;; 5. In conjunction with products arising from the use of this material,
;;;    there shall be no use of the name of the Yale University nor of any
;;;    adaptation thereof in any advertising, promotional, or sales literature
;;;    without prior written consent from Yale in each case.
;;;

(define-constant call-foreign 
  (primop call-foreign ()
    ((primop.make-closed self)
     '(lambda args (error "DEFINE-FOREIGN cannot be interpreted")))
    ((primop.generate self node)
     (generate-foreign-call node))))

;;; COMPARATORS
;;;===========================================================================

(define-constant eq?
  (primop eq? ()
    ((primop.generate self node)
     (eq?-comparator node))
    ((primop.presimplify self node)
     (presimplify-to-conditional node))
    ((primop.simplify self node)
     (simplify-eq? node))
    ((primop.make-closed self)
     (make-closed-conditional self))
    ((primop.conditional? self) t)
    ((primop.conditional-type self node)
     '#[type (proc #f (proc #f) (proc #f) top top top)])
    ((primop.type self node)
     '#[type (proc #f (proc #f boolean) top top)])))
       
;;; TYPE PREDICATES
;;;===========================================================================

(define-local-syntax (define-tag-type-predicate name tag)
  `(define-constant ,name
     (make-tag-type-predicate ',name ,tag)))

(define-local-syntax (define-header-type-predicate name header)
  `(define-constant ,name
     (make-header-type-predicate ',name ,header)))


(define-constant make-tag-type-predicate 
  (primop make-tag-type-predicate (name tag)

    (((primop.simplify self node)
      (simplify-parameterized-primop self node)))

    ((primop.test-code self node #f)      
     (generate-tag-type-test node tag))
    ((primop.presimplify self node)
     (presimplify-predicate node))
    ((primop.make-closed self)
     (make-closed-predicate self))
    ((primop.type-predicate? self) t)
    ((primop.type self node)
     '#[type (proc #f (proc #f boolean) top)])
    ((primop.predicate-type self node)
     '#[type (proc #f (proc #f) (proc #f) top top top)])
    ((primop.variant-id self) name)))

(define-constant make-header-type-predicate
  (primop make-header-type-predicate (name header)

    (((primop.simplify self node)
      (simplify-parameterized-primop self node)))

    ((primop.test-code self node #f)
     (generate-header-type-test node header))
    ((primop.presimplify self node)
     (presimplify-predicate node))
    ((primop.make-closed self)
     (make-closed-predicate self))
    ((primop.type-predicate? self) t)
    ((primop.type self node)
     '#[type (proc #f (proc #f boolean) top)])
    ((primop.predicate-type self node)
     '#[type (proc #f (proc #f) (proc #f) top top top)])
    ((primop.variant-id self) name)))

                     
(define-tag-type-predicate list?    tag/pair)         ; low 2 bits
(define-tag-type-predicate extend? tag/extend)
(define-tag-type-predicate immediate? tag/immediate)
(define-tag-type-predicate fixnum?   tag/fixnum)

(define-header-type-predicate char?                   header/char)
(define-header-type-predicate general-vector-header?  header/general-vector)
(define-header-type-predicate bytev-header?           header/bytev)
(define-header-type-predicate text-header?            header/text)
(define-header-type-predicate string-header?          header/slice)
(define-header-type-predicate symbol-header?          header/symbol)
(define-header-type-predicate foreign-header?         header/foreign)
(define-header-type-predicate vcell-header?           header/vcell)
(define-header-type-predicate true-header?            header/true)
(define-header-type-predicate unit-header?            header/unit)
(define-header-type-predicate interrupt-frame-header? header/interrupt-frame)
(define-header-type-predicate fault-frame-header? header/fault-frame)
(define-header-type-predicate bignum-header?          header/bignum) 
(define-header-type-predicate double-float-header?    header/double-float)
(define-header-type-predicate template-header?        header/template)
                       
(define-header-type-predicate weak-set-header?    header/weak-set)
(define-header-type-predicate weak-alist-header?  header/weak-alist)
(define-header-type-predicate weak-table-header?  header/weak-table)
(define-header-type-predicate weak-cell-header?   header/weak-cell)

                                                      
(define-constant nonvalue?
  (primop nonvalue? ()
    ((primop.test-code self node #f)
     (generate-nonvalue-test node))
    ((primop.presimplify self node)
     (presimplify-predicate node))
    ((primop.make-closed self)
     (make-closed-predicate self))
    ((primop.type-predicate? self) t)
    ((primop.type self node)
     '#[type (proc #f (proc #f boolean) top)])
    ((primop.predicate-type self node)
     '#[type (proc #f (proc #f) (proc #f) top top top)])))
                                                      

                                                

;;; MAKE-VECTORS
;;;=========================================================================

(define-constant make-vector-extend
  (primop make-vector-extend ()
    ((primop.generate self node)
     (generate-make-vector-extend node))))

(define-constant %make-extend
  (primop %make-extend ()
    ((primop.generate self node)
     (generate-make-extend node))
    ((primop.type self node)
     '#[type (proc #f (proc #f top) template fixnum)])))

;;; MAKE-PAIR

(define-constant %make-pair
  (primop %make-pair ()
    ((primop.generate self node)
     (generate-make-pair node))
    ((primop.type self node)
     '#[type (proc #f (proc #f pair))])))

;;; ONE-ARG-PRIMITIVES
;;;==========================================================================
                      
(define-constant descriptor->fixnum
  (primop descriptor->fixnum ()
    ((primop.generate self node)
     (generate-one-arg
      node
      (lambda (acc t-reg)
	(emit risc/srl (machine-num 2) acc scratch)
	(emit risc/sll (machine-num 2) scratch t-reg)
	(mark-continuation node t-reg))))
    ((primop.type self node)
     '#[type (proc #f (proc #f fixnum) top)])))

(define-constant descriptor-tag
  (primop descriptor-tag ()
    ((primop.generate self node)
     (generate-one-arg
      node
      (lambda (acc t-reg)
	(emit risc/sll (machine-num 2) acc t-reg)
	(emit risc/and (machine-num #xF) t-reg t-reg)
	(mark-continuation node t-reg))))
    ((primop.type self node)
     '#[type (proc #f (proc #f fixnum) top)])))
                                           
(define-constant header-type
  (primop header-type ()
    ((primop.generate self node)
     (generate-one-arg
      node
      (lambda (acc t-reg)
	(emit risc/and (machine-num #x7c) acc t-reg)
	(mark-continuation node t-reg))))
    ((primop.type self node)
     '#[type (proc #f (proc #f fixnum) top)])))


                            
(define-constant %chdr
  (primop %chdr ()
    ((primop.side-effects? self) t)
    ((primop.generate self node)
     (generate-%chdr node))))



