(herald vaxfix)



(define (generate-op-with-overflow node op) 
  (destructure (((then else () ref1 ref2) (call-args node)))
    (let ((reg1 (register-loc (leaf-value ref1)))
          (reg2 (register-loc (leaf-value ref2))))
      (xcase op
	((add) (emit vax/addl2 reg2 reg1))
	((subtract) (emit vax/subl2 reg2 reg1))
	((multiply)
	 (emit vax/ashl ($ -2) reg1 reg1)
	 (emit vax/mull2 reg2 reg1)))
      (emit-jump jump-op/overflow then else)                               
      (kill (leaf-value ref1))
      (kill (leaf-value ref2))
      (mark (car (lambda-variables else)) reg1))))

(define (generate-hack-dr node op)
  (destructure (((#f ref1 ref2) (call-args node)))
    (let ((reg1 (register-loc (leaf-value ref1)))
          (reg2 (register-loc (leaf-value ref2))))
      (xcase op
	((divide)
	 (emit vax/divl2 reg2 reg1)
	 (emit vax/ashl ($ 2) reg1 reg1))
	((remainder)
	 (lock reg1)
	 (lock reg2)
	 (let ((temp (get-register 'scratch node '*)))
	   (unlock reg1)
	   (unlock reg2)
	   (emit vax/divl3 reg2 reg1 temp)
	   (emit vax/mull2 reg2 temp)
	   (emit vax/subl2 temp reg1))))
      (kill (leaf-value ref1))
      (kill (leaf-value ref2))
      (mark-continuation node reg1))))







