(herald (back_end reg)
  (env t (orbit_top defs) (back_end closure) (back_end bookkeep)))

(define (allocate-conditional-primop node prim)
  (primop.generate prim node)      
  (let ((then (then-cont node))
        (else (else-cont node)))
  (receive (then else) (cond ((or (leaf-node? then) 
                                  (leaf-node? else) 
                                  (fx< (lambda-trace then)
                                       (lambda-trace else)))
                              (return then else))
                             (t
                              (return else then)))
    (let ((registers (swap *registers* (copy-registers)))
	  (lam *lambda*)
	  (heap-env *heap-env*))
      (emit-tag then)  
      (cond ((lambda-node? then)
             (walk (lambda (n)
                     (kill-if-dead n then))
                   (cons else (cddr (call-args node))))
             (allocate-call (lambda-body then)))
            (t
             (allocate-conditional-continuation node then)))
      (return-registers)
      (set *lambda* lam)
      (set *heap-env* heap-env)
      (set *registers* registers))
    (restore-slots)
    (emit-tag else)  
    (cond ((lambda-node? else)
           (walk (lambda (n)
                   (kill-if-dead n else))
                 (cons then (cddr (call-args node))))
           (allocate-call (lambda-body else)))
          (t
           (allocate-conditional-continuation node else))))))


