(herald spbookkeep); (env t (orbit_top defs)))

;;; Copyright (c) 1985 Yale University
;;;     Authors: N Adams, R Kelsey, D Kranz, J Philbin, J Rees.
;;; This material was developed by the T Project at the Yale University Computer 
;;; Science Department.  Permission to copy this software, to redistribute it, 
;;; and to use it for any purpose is granted, subject to the following restric-
;;; tions and understandings.
;;; 1. Any copy made of this software must include this copyright notice in full.
;;; 2. Users of this software agree to make their best efforts (a) to return
;;;    to the T Project at Yale any improvements or extensions that they make,
;;;    so that these may be included in future releases; and (b) to inform
;;;    the T Project of noteworthy uses of this software.
;;; 3. All materials developed as a consequence of the use of this software
;;;    shall duly acknowledge such use, in accordance with the usual standards
;;;    of acknowledging credit in academic research.
;;; 4. Yale has made no warrantee or representation that the operation of
;;;    this software will be error-free, and Yale is under no obligation to
;;;    provide any services, by way of maintenance, update, or otherwise.
;;; 5. In conjunction with products arising from the use of this material,
;;;    there shall be no use of the name of the Yale University nor of any
;;;    adaptation thereof in any advertising, promotional, or sales literature
;;;    without prior written consent from Yale in each case.
;;;


(define *stack-registers* 0)
(define *real-registers*
  (+ *argument-registers* *stack-registers* 3)) ;an,p,an+1
(define *first-stack-register* (+ *argument-registers* 3))
(define AN (fx+ *argument-registers* 1)) ;i4
(define AN-1 (fx- AN 1))
(define AN+1 (fx+ AN 1))		;g3
(define *virtual-registers* 128)

(define P 0)				;l0
(define A1 1)				;l1
(define A2 2)
(define A3 3)
(define A4 4)
(define A5 5)
(define A6 6)
(define A7 7)				;l7
(define A8 8)				;i0
(define A9 9)				;i1
(define A10 10)
(define A11 11)				;i3


(define zero -1)			;g0
(define extra-args -2)			;o1
(define EXTRA -3)			;o2
(define scratch -4)			;o5
(define nil-reg -5)			;i5
(define parassign-extra -6)		;o3
(define VECTOR -7)			;o4
(define t-reg -8)			;g2
(define sp -9)				;g1
(define link-reg -10)			;o7
(define ass-reg -11)			;o0
(define crit-reg -12)			;i7
(define ssp -13)			;o6

(define nargs scratch)


#|
(define *stack-registers* 13)
(define *real-registers*
  (+ *argument-registers* *stack-registers* 3)) ;an,p,an+1
(define *first-stack-register* (+ *argument-registers* 3))
(define AN (fx+ *argument-registers* 1)) ;o0
(define AN-1 (fx- AN 1))
(define AN+1 (fx+ AN 1))		;o1
(define *virtual-registers* 64)

(define S0 (+ AN 2))
(define S1 (+ AN 3))
(define S2 (+ AN 4))
(define S3 (+ AN 5))
(define S4 (+ AN 6))
(define S5 (+ AN 7))
(define S6 (+ AN 8))

(define P 0)				;g1
(define A1 1)				;g2
(define A2 2)				;g3
(define A3 3)				;g4
(define A4 4)				;g5
(define A5 5)				;g6

(define zero -1)			;g0
(define extra-args -2)			;o2
(define EXTRA -3)			;o3
(define scratch -4)			;o4
(define nil-reg -5)			;g7
(define parassign-extra -6)		;i0
(define VECTOR -7)			;o5
;(define t-reg -8)			
(define sp -8)				;o6
(define link-reg -9)			;o7
;(define ass-reg -11)			
;(define crit-reg -12)
;(define ssp -13)
(define nargs scratch)
|#
(define ($ x) (error "used $"))

(define-integrable (reg-offset x y) (cons x y))
#|
(define (machine-true-value) (machine-num header/true))
|#

(define (machine-true-value) t-reg)

(define (representable-fixnum? x op)                 
  (and (fixnum? x)
       (fx>= x #x-400)
       (fx< x #x400)))			;13 bits signed -2

(define *max-displ* #xfff)

(define *max-extend-displ* (- #xfff 2))

(define (addressable? value)
  (or (target-fixnum? value)
      (char? value)
      (eq? value '#t)
      (eq? value '#F)))

(define-constant target-fixnum? fixnum?)

(define-integrable (machine-num x)
  (if (fx= x 0) zero (cons 'lit x)))
(define-integrable (unsigned-num x) (cons 'unsigned x))

(define (reference-addressable node x)
  (xcond ((representable-fixnum? x 'move)
	  (machine-num (* x 4)))
         ((or (fixnum? x) (char? x))
	  (let ((reg (get-register node)))
	    (generate-move-addressable x reg)
	    (mark x reg)
	    reg))
	 ((not x) nil-reg)
	 ((eq? x '#t) (machine-true-value))))


(define-integrable (register? x)
  (and (fixnum? x) (fx< x *real-registers*)))


(define (allowed-mode? x)
  (or (register? x)
      (and (pair? x)
	   (eq? (car x) 'lit))))


(define (arith->addressable node var op)
  (cond ((representable-fixnum? var op)
	 (machine-num (fx* var 4)))
	(else
	 (->register node var))))

