(herald fix1)

(define (analyze-Y cont master depth -trace)
  (let* ((lambdas (call-args (lambda-body master)))
         (strategy (get-labels-strategy master)))
    (walk (lambda (var l) 
            (set (lambda-strategy l) strategy)
            (if var (set (variable-type var) l)))
          (cdr (lambda-variables master))
          (cdr lambdas))                                  
    (set (lambda-strategy master) strategy)
    (set (lambda-strategy (car lambdas)) strategy/open)
    (let ((tr (cond ((not (lambda-node? cont)) -trace)
                    ((and (eq? strategy strategy/label)
			  (constant-continuation? master)
			  (check-continuation-refs lambdas
						   (lambda-variables master)))
                     (set (lambda-strategy cont) strategy/label)
                     (walk (lambda (l)
                             (set (variable-type (lambda-cont-var l)) cont))
                           (cdr lambdas))
                     (analyze-lambda cont (fx+ depth 1) -trace))
		    (else
                     (set (lambda-strategy cont) strategy/stack)
                     (analyze-lambda cont (fx+ depth 1) -trace)))))
      (really-analyze-body lambdas (fx+ depth 1) tr))))

(define (check-continuation-refs l vars)
  (every? (lambda (l)
	    (every? (lambda (ref)
		      (or (eq? (node-role ref) call-proc)
			  (let ((proc (call-proc (node-parent ref))))
			    (memq? (reference-variable proc) vars))))
		    (variable-refs (lambda-cont-var l))))
	  l))

(define (live-analyze-leaf node)
  (cond ((literal-node? node)
         (cond ((or (addressable? (leaf-value node))
                    (primop? (leaf-value node)))
                (return '() nil '()))
               (else
                (return '() t '()))))
        ((primop-node? node)
         (cond ((foreign-name (primop-value node))
                (return '() t '()))
               (else 
                (return '() nil '()))))
        ((variable-known (reference-variable node))
         => (lambda (label)
              (select (lambda-strategy label)
                ((strategy/label)
                 (return (lambda-live label)
                         (eq? (lambda-env label) 'needs-link)
                         (if (labels-lambda? label) 
                             (list label)  
                             '())))
                ((strategy/stack)
                 (return '() nil '()))
                (else 
                 (if (eq? (lambda-env label) 'unit-internal-closure)
                     (return '() t '())
                     (return `(,(lambda-self-var label)) nil '()))))))
        ((bound-to-continuation? (reference-variable node))
         (return '() nil '()))
        ((variable-binder (reference-variable node))
         (return `(,(reference-variable node)) nil '()))
        (else 
         (return '() t '()))))

(define (sort-by-difficulty args pos-list)
  (iterate loop ((args args) (do-now '()) (trivial '()) (do-later '())
                 (pos-list pos-list))
    (cond ((null? args)
           (return do-now trivial do-later))
          ((lambda-node? (car args)) 
           (let ((l (car args)))
             (cond ((eq? (environment-closure (lambda-env l)) *unit*)
                    (loop (cdr args)
                          do-now
                          trivial
                          (cons (cons l (car pos-list)) do-later)
                          (cdr pos-list)))
                   (else
                    (loop (cdr args)
                          do-now
                          (cons (cons l (car pos-list)) trivial)
                          do-later
                          (cdr pos-list))))))
          ((addressable? (leaf-value (car args)))
           (loop (cdr args)
                 do-now
                 (cons (cons (car args) (car pos-list)) trivial)
                 do-later
                 (cdr pos-list)))
          (else
           (let* ((val (leaf-value (car args)))
                  (value (cond ((and (variable? val) (variable-known val))
                               => lambda-self-var)
                              (else val))))
             (cond ((let ((reg (register-loc value))
		          (temp (temp-loc value)))
	   	      (if (and reg temp (eq? temp (car pos-list)))
   			  temp
			  (or reg temp)))   
                    => (lambda (reg)
                         (loop (cdr args)
                               (cons (mover reg (car pos-list))
                                     do-now)
                               trivial
                               do-later
                               (cdr pos-list))))
                   (else
                    (loop (cdr args)
                          do-now
                          trivial
                          (if (fx= (car pos-list) P)
                              (append! do-later (list (cons value (car pos-list))))
                              (cons (cons value (car pos-list)) do-later))
                          (cdr pos-list)))))))))



                          
(define (live-analyze-lambda node)
  (receive (live global? known) (live-analyze-body (lambda-body node))
   (let* ((live-1 (set-difference live (lambda-all-variables node)))
           (live (if (neq? (node-role node) call-proc)  ;; Let
                     live-1       
                     (set-difference live-1 (map (lambda (node) 
                                            (and (lambda-node? node)
                                                 (lambda-self-var node)))
                                          (call-args (node-parent node)))))))
    (set (lambda-live node) live)
    (select (lambda-strategy node)
      ((strategy/heap)    
       (walk change-to-heap known)
       (cond ((and (null? live) (not (known-lambda? node)))
              (set (lambda-env node) 'unit-internal-closure)
              (return live t known))
             (global? 
              (set (lambda-env node) 'unit-internal-template)
              (return live t known))
             (else
              (set (lambda-env node) nil)
              (return live nil known))))
      ((strategy/label)                
       (cond ((fully-recursive? node)
	      (walk change-to-vframe-or-heap 
		    (if (memq? node known) known (cons node known)))))
       (set (lambda-env node) (if global? 'needs-link '#f))
       (return live global? known))
      ((strategy/stack)           
       (set (lambda-env node) (if global? 'needs-link '#f))
       (walk (lambda (l)
	       (if (fully-recursive? l)
		   (change-to-heap l)))
	     known)
       (return live global? known))
      (else
       (return live global? known))))))


(define (create-join-point env contour needed? lamb)
  (let ((j (make-join-point)))
    (set (join-point-env j) env)
    (set (join-point-arg-specs j) nil)
    (set (join-point-global-registers j) 'not-yet-determined)
    (set (join-point-contour-needed? j) needed?)
    (set (join-point-contour j) contour)
    (set (join-point-call-below? j) 
	 (if (continuation? lamb)
nil;	     (fx= (call-below? (lambda-body lamb)) call-below/definitely)
	     (fx>= (call-below? (lambda-body lamb)) call-below/maybe)))
    j))

(define (analyze top-node)
  (analyze-top top-node)
  (live-analyze-top top-node)
  (collect-top top-node)
  (call-analyze-top top-node)
  (bind ((*noise-flag* t))
    (print-variable-info *unit-variables*))
;  (type-analyze-top top-node)
;  (rep-analyze-top top-node)
  (hoist-continuations (lambda-body top-node))
  (close-analyze-top top-node nil))

(define-constant call-below? node-instructions)
(define-constant call-below/never 0)
(define-constant call-below/maybe 1)
(define-constant call-below/definitely 2)


(define (call-analyze-top node)
  (call-analyze (lambda-body node)))



(define (call-analyze-leaf node)
  (cond ((lambda-node? node)
	 (let ((call-below? (call-analyze (lambda-body node))))
	   (select (lambda-strategy node)
	     ((strategy/stack) call-below/definitely)
	     ((strategy/heap) call-below/never)
	     (else call-below?))))
	(else
	 call-below/never)))

(define (call-analyze node) 
  (let ((below?
       (case (call-exits node)
	 ((0)
	  (cond ((lambda-node? (call-proc node))
		 (call-analyze-let node))
		(else
		 (walk call-analyze-leaf (call-args node))
		 (call-analyze-known (call-proc node)))))
	 ((1)
	  (cond ((primop-ref? (call-proc node) primop/y)
		 (destructure (((cont master) (call-args node)))
                   (call-analyze-leaf cont)
		   (destructure (((body-expr . label-exprs) 
				  (call-args (lambda-body master))))
		     (let ((v (call-analyze-leaf body-expr)))
		       (cond ((or (and (lambda-node? cont)
				       (eq? (lambda-strategy cont)
					    strategy/stack))
				  (fx= v call-below/definitely))
			      (walk call-analyze-leaf label-exprs)
			      call-below/definitely)
			     (else
			      (do ((l label-exprs (cdr l))
				   (val v (call-below-combine 
					   val
					   (call-analyze-leaf (car l)))))
				  ((null? l) val))))))))
		((lambda-node? (call-proc node))
		 (call-analyze-let node))
		(else
		 (destructure (((exit . rest) (call-args node)))
                   (walk call-analyze-leaf rest)
		   (cond ((lambda-node? exit)
			  (call-analyze-leaf exit))
			 (else
			  (call-analyze-known (call-proc node))))))))
	 (else
	  (destructure (((th el . rest) (call-args node)))
	    (walk call-analyze-leaf rest)
	    (call-below-combine (call-analyze-leaf th) (call-analyze-leaf el)))))))
    (set (call-below? node) below?)
    below?))

(define (call-analyze-let node)
  (iterate loop ((args (call-args node))
		 (val call-below/never))
    (cond ((null? args) 
	   (let ((body-val (call-analyze-leaf (call-proc node))))
	     (cond ((fx= body-val call-below/definitely)
		    body-val)
		   (else 
		    (call-below-combine val body-val)))))
	  ((lambda-node? (car args))
	   (loop (cdr args)
		 (call-below-combine 
		  val 
		  (call-analyze-leaf (car args)))))
	  (else
	   (loop (cdr args) val)))))

(define (call-analyze-known proc)
    (cond ((and (reference-node? proc)
		(variable-known (reference-variable proc)))
	   => (lambda (l) 
		(let ((cb (call-below? (lambda-body l))))
		  (if (fixnum? cb) cb call-below/never))))
	  (else call-below/never)))


(let ((vec '#(#(0 1 1) #(1 1 1) #(1 1 2))))
  (define (call-below-combine x y)
    (vref (vref vec x) y)))
     