_Chapter(Syntax and semantics)
_label(chapter:semantics)

This chapter gives an overview of _T as a programming language.

The _T language logically comprises three distinct components:
_begin_Itemize
_Item()an _iix(external representation) for objects as character sequences,

_Item()a _iix(core language) - syntax and semantics for expressions, and

_Item()a _iix(standard environment) - the behavior of the objects
which are values of system variables.
_end_Itemize

_Section(External representation)

Like other Lisp dialects, and in contrast with most other
programming languages, _T has two different kinds of syntax: the
_iix(external representation) by which objects (data) are represented as a
linear sequence of characters, and an _iix(expression syntax) by which
these objects can be understood as programs.  _index(objects)
That is, the meaning of a _T program represented as characters in a file
or other external storage medium must be determined in two stages:
first, by mapping the characters to objects, and then by interpreting
these objects as executable programs.

The external syntax of _T is very similar to that of other Lisp
dialects, and is discussed in detail at appropriate places in this manual.
The following gives only the most cursory description.
_DComment( Uck!!! )
Characters may be classified according to their lexical properties; the
two most important distinctions are between _Fit(constituent) and
_Fit(delimiter) characters, and between _Fit(read-macro) characters and
non-read-macro characters.  Alphabetic, numeric, and some special
characters (e.g. _tc(-) and _tc(_cDL())) are constituent characters;
whitespace and some special characters (e.g. left and right parenthesis) are
delimiter characters.  Some special characters such as _tc(_cPo) and _cQc
are read-macro characters; these introduce special syntactic constructs
which are idiosyncratic to the particular character introducing them.

A delimited sequence of consecutive constituent characters represents
either a _iix(number) or a _iix(symbol).  For example, _tc(255) represents
the integer 255, and _tc(APPEND) and _tc(append) both represent the
symbol _tc(APPEND).  Here, and throughout the manual, the term
_Fit(symbol) is being used in a technical manner to refer a particular
kind of named object (see section _Ref(section:symbols)).

Balanced parentheses with a sequence of (representations of) objects
between them represent a list of the (represented) objects.  For
example, the characters _wt((A B (C 12) D)) represent a list of four
objects, three of which are symbols, and one of which (the third one) is
a list of two objects, the symbol _tc(C) and the integer 12.
Parentheses which enclose no objects represent an empty list.

There are also external representations for strings and characters, as
well as for some kinds of objects which are syntactically illegal
as expressions (for example, vectors).  Not all objects have external
representations, however.

_Section(Core language)
_label(section:coreLanguage)
The core language is described in terms of a hypothetical machine
(called an _iix(evaluator)) which executes _T code directly.  In
practice, the existing _T implementations have (at least) two
evaluators, both of which perform evaluation as a two-stage process
consisting of compilation (syntactic and semantic analysis) followed by
interpretation.

_Fit(Evaluation)_index(evaluation) is a process whereby an object called an _Fit(expression)
_index(expressions) (the term _Fit(form)_index(forms) is used synonymously
with _Fit(expression)) is mapped to another object, called its
_Fit(value).  Evaluation occurs in the context of a particular
_Fit(variable environment)_index(environments); see below.  The expression
is said to _iix(yield) its value.
_index(variables)

The evaluation mapping is not a purely mathematical mapping, since in
some cases the evaluation of an expression may depend not only on the
variable environment but on the _iix(state) of the running _T
system, or on the state of the world outside it; and evaluation may
cause changes in the state of system or the world, which may, in turn,
affect future evaluations.  These state changes are called
_iix(side-effects).

The rules by which an object is evaluated are as follows:

_Fit(Self-evaluating literals:)_index(literals)
All numbers, strings, and characters are syntactically valid
expressions which, when evaluated, yield themselves.
For example,
_begin_ExampleTabular
-2102        _colsep _evalto()  _colsep -2102 _LNL
_char(M)         _colsep  _evalto()  _colsep _char(M) _LNL
"A string."  _colsep _evalto() _colsep  "A string."
_end_ExampleTabular

The notation _qu(_Fit(expression) _evalto() _Fit(value)) means that
_Fit(expression), when evaluated, yields _Fit(value).  (Note also that we are
making use of the external object syntax itself as a notational device:
_qu(the object _tc(-2102)) could be said more precisely as _qu(an object
externally represented by the characters _qu(_tc(-2102)).)  Just as a
program should never be confused with an object which represents it, an
object should never be confused with a sequence of characters
which notates it.)

_Fit(Symbols:)_index(symbol)
As evaluable expressions, symbols are interpreted as variable
references.  A
symbol evaluates to its value according to the current variable
environment.  For example, in an environment in which the variable
_tc(DELTA) has the value _tc(15), evaluating the expression
_tc(DELTA) will yield _tc(15).
_index(variables)

Symbols have many uses other than as names for variables.
It is important not to confuse the use of a symbol as a datum
manipulated by a program with the occurrence of a symbol
as a variable reference in a program.  Symbols do not have values
_Fit(a priori); variables only have values by virtue of the context
in which they occur.

_Fit(Lists:)_index(lists)
Non-empty lists are classified either as _iix(calls) or as _iix(special
forms).  If the first element of the list is a symbol, and the symbol is
a _iix(reserved word), then the list is a special form; otherwise it is
considered to be a _Fit(call).  _T reserved words
include, for example, the symbols _tc(QUOTE), _tc(IF),
and _tc(LAMBDA).  (However, see section _Ref(section:syntaxTables).)

_Fit(Special forms:)_index(special forms)
The syntax and semantics of a special form are
idiosyncratic to the reserved word which introduces it; descriptions of
the meaning of expressions introduced by the various reserved words are
therefore distributed throughout the manual.

_Fit(Calls:)_index(calls)
_label(CallSemantics)
Calls are evaluated as follows: the elements of the list (including the
first) are evaluated, _Fbf(in an undefined order).  The first must evaluate
to a procedure; this procedure is _Fit(applied) _index(application) to the
rest of the values, which are called _iix(arguments).
(The verbs _Fit(call) and _Fit(invoke) mean the same as _Fit(apply).)
_index(calling) _index(invoking)

The evaluation order of arguments in a combination is undefined.
_orbit produces
code in which the evaluation order of arguments is undefined
and not necessarily left to right.

Particularly insidious bugs have resulted from _key(LET),
see page _Pageref(LET),
forms whose clauses contain order dependent side effects.  In
_Tv(2), because
_tc(TC) and the standard compiler evaluated the clauses of
_key(LET) forms of this sort in sequential order they produced
the expected value.  _orbit will usually _Fit(not) produce the
expected value. _key(_a(LET,_star)) should be used to ensure
sequential evaluation order.

_Comment(
%
% Application is a process performed idiosyncratically to the procedure
% being invoked, and so the description of application is decentralized,
% appearing distributed throughout the manual.  For example, in the
% standard environment, the variable _tc(CAR) has as its value a procedure
% which takes the first element of a list.  The manual entry for _tc(CAR)
% describes what happens when this procedure is applied to an argument,
% and thus constitutes, in part, a description of application.  Similarly,
% the entry for _tc(LAMBDA) describes what happens when a procedure
% created by a _tc(LAMBDA)-expression is invoked.
)
_Section(The standard environment)
_label(section:standardEnvironment)
The standard environment corresponds to what is usually known as the
_qu(run-time library) in other language environments such as C or Pascal.

New variable environments may be introduced in various ways (see chapter
_Ref(chapter:environments)), but a _T system is obliged to supply one
standard environment in which system variables are bound to system
procedures and constants, as defined by this manual.  Program execution
typically occurs in an environment inferior to this standard environment
(see section _Ref(STANDARD-ENV)), so that these objects are easily
accessible as values of lexically apparent variables.  For example,
in this standard environment, the variable _tc(CONS) has a certain
procedure as its value.

For the most part, the values of system variables are procedures, and
therefore the only behavior of interest is what they do when called.
(See the discussion of calls, above.)  In other cases, values are objects
such as numbers or symbols.

A representation of the standard environment is available as the value
of _tc(STANDARD-ENV) (page _Pageref(STANDARD-ENV)).

_Section(Undefined)
_label(section:undefinedSemantics)

The term _iix(undefined) is used in two different ways in this manual.
An expression may _Fit(yield an undefined value), in which case it yields
some value, the particular value not being defined by this manual.  In
such cases it is unwise to depend on this value having any particular
characteristics, for example, it being null, or not a number, or
whatever.  The evaluation of the expression and the creation of the
undefined value are not in error; it is the use to which this value is
put that may lead to problems.  Expressions yielding undefined values
are generally useful only for any side-effects they cause.

On the other hand, the evaluation of an expression may _Fit(have an
undefined effect), in which case an implementation will endeavor to
signal an error condition, permitting a user to take appropriate action.
For example, a call to a non-procedure, or adding two symbols together,
have undefined effects.  An implementation is not _Fit(obliged,) however,
to signal an error, and in fact it may be in the interest of efficiency
to avoid the overhead of detecting circumstances under which undefined
effects will happen.

The two procedures _tc(UNDEFINED-VALUE) and _tc(UNDEFINED-EFFECT)
are used for expository purposes in examples throughout this manual;
they are described in section _Ref(section:undefined).

_Section(Multiple values)
_label(section:multipleValues)

_T now supports multiple return values.  This makes
procedure call and return uniform, in the sense that a procedure
can be invoked with zero or more values and can return zero
or more values. See page _Pageref(subsection:multipleReturnValues).

Like procedures, continuations have certain expectations about the
number of arguments (values) that will be delivered to them.  It is an
error if more or fewer values are delivered than expected.

The idiom _wt((RETURN)) is useful for procedures that return
an undefined value and many of the system procedures whose value(s)
is undefined now return no value.  However,  the procedure
_wt(undefined-value) may provide a more informative error
message.

Other forms,  such as _wt(CATCH) and _wt(RET),
have been extended to allow multiple return
values.
