_ChapUnum(Preface,Old Preface,Top,Top)
_label(chapter:preface)

This manual describes _T, a programming language being developed at the
Yale University Computer Science Department _cite(Rees82), and its
current implementations.  It is a reference manual, intended to define
the language and to describe the general direction of its development.
It is _Fit(not) intended as an introduction or a tutorial.

The bulk of this document describes _T as a programming language.
However, chapters _Ref(chapter:program),
_Ref(chapter:user),
and _Ref(chapter:debug) describe pragmatic features which are
specific to the current implementations.

The reader is expected to have some programming experience; the reader
may also find a knowledge of Lisp helpful, although _T is different
enough from Lisp that prior experience with Lisp might actually be
a hindrance.

Chapter _Ref(chapter:future) describes ways in which
the language is deficient and directions in which it is likely to grow.
Also, the implementations are not faithful to the language definition presented
in the manual; section _Ref(section:bugs) catalogs known deviations.

Please send questions and comments about the language, this manual,
or the various implementations of the system, via Internet mail to
T-Project@Yale.Edu, or via U.S. Mail to
_begin_Display
T Project _LNL
Department of Computer Science _LNL
Yale University _LNL
P.O. Box 2158 Yale Station _LNL
New Haven, Connecticut 06520 _LNL
_end_Display

Announcements of interest to _T users are regularly broadcast
via Arpanet and Usenet electronic mail to the mailing list
T-Discussion@MC.LCS.MIT.EDU;
send mail to T-Discussion-Request@MC.LCS.MIT.EDU if you
want to be added to (or removed from) this list.  Send reports
about errors in the manual or implementations to _Ftt(T3-Bugs@YALE.EDU).

To be added to the Scheme mailing list send mail to
Scheme-Request@MC.LCS.MIT.EDU, or subscribe to the comp.lang.scheme
Usenet newsgroup.

The _T project has been funded exclusively by the Computing Facility
of the Yale Computer Science Department.
_DComment(dorab: fix for info)
_IfLatex(`\footnotetext{%')
VMS, and VAX are trademarks of Digital Equipment Corporation.
Domain and Aegis are trademarks of Apollo Computer, Inc.  UNIX is a
trademark of Bell Laboratories.
_IfLatex(`}')

The Fifth Edition of the _T Manual is the result of converting the 1984
_Tv(2.7) manual to LaTeX and then slapping in the release notes from
_Tv(3.0) and _Tv(3.1).  The _Tv(3.0) release notes were written by James
Philbin.  The _Tv(3.1) release notes are by David Kranz.  Most of the
work in converting the original Scribe sources to LaTeX was done
by Mitchell Charity. Final cleaning up and some amount of integration
was done by Dorab Patel. Thanks to Jonathan Rees, David Kranz, (and
others to be mentioned), who helped with the cleanup.

_ChapUnum(Acknowledgements)

The authors wish to thank Kent Pitman for his continuing assistance
in making _T true.

Gerry Sussman has provided essential guidance and inspiration.

Guy Steele wrote most of the compiler we're using, and has otherwise
been a strong influence, originating much of the project's design
philosophy and shaping and inspiring many of its features.

This document borrows from the _Fit(Lisp Machine Manual) _cite(Weinreb81)
and the _Fit(Common Lisp Reference Manual) _cite(CLtL).
We are grateful to their authors.

We wish to acknowledge the influence and valuable advice provided
during the design process by the following people at Yale, MIT, and
elsewhere:  Alan Bawden, Richard Bryan,
David Byrne,
George Carrette, William
Clinger, Peter Deutsch, John Ellis, William Ferguson, Christopher
Hanson, Carl Hoffman, David Kranz, David Littleboy,
Drew McDermott, Nathaniel Mishkin,
Robert Nix, Jim Philbin, John Ramsdell, Christopher Riesbeck, John
Ruttenberg, Olin Shivers, and Steve Wood.

Thanks to Judy Martel for her patient proofreading.

The NIL project at MIT was the source of many of _T's good ideas.
NIL is the work of Richard Bryan, Glenn Burke, George Carrette, Michael
Genereseth, Robert Kerns, Jim Purtilo, John White, and one of the
present authors (JR).

Jim Purtilo wrote the integer arithmetic package used in the current
implementation while he was working on the NIL project.

We appreciate the patience of our user community, at Yale and elsewhere,
who have had to put up with an incompatible, incomplete, and untuned new
system.

Finally, we wish to thank John O'Donnell for helping to shelter us from
the real world, and for having the foresight, or perhaps folly, to
initiate the project in the first place.
