;(eval-when (compile) (proclaim '(optimize (speed 3) (safety 0) (space 2))))

(defvar any '#!unspecified)

(defvar host-macs
  '(lambda if set! define! let cond begin define and or rec let* letrec
     iterate freeze delay begin0 apply-if macro alias step engine
     autoload mulambda sigma mvlet mvlet* semantic-mode-reset))

(defun host-mac-dispatch (e)
      (let ((mac (car e)))
	 (cond
	    ((eq mac 'lambda) (host-lambda e))
	    ((eq mac 'if) (host-if e))
	    ((eq mac 'set!) (host-set! e))
	    ((eq mac 'cond) (host-cond e))
   	    ((eq mac 'let) (host-let e))
	    ((eq mac 'begin) (host-begin e))
	    ((eq mac 'define!) (host-define! e))
	    ((eq mac 'define) (host-define e))
	    ((eq mac 'and) (host-and e))
	    ((eq mac 'or) (host-or e))
	    ((eq mac 'case) (host-case e)) ; remember to put case back in list
	    ((eq mac 'rec) (host-rec e))
	    ((eq mac 'let*) (host-let* e))
	    ((eq mac 'letrec) (host-letrec e))
	    ((eq mac 'iterate) (host-iterate e))
	    ((eq mac 'freeze) (host-freeze e))
	    ((eq mac 'delay) (host-delay e))
	    ((eq mac 'begin0) (host-begin0 e))
	    ((eq mac 'apply-if) (host-apply-if e))
	    ((eq mac 'macro) (host-macro e))
	    ((eq mac 'alias) (host-alias e))
	    ((eq mac 'mvlet) (host-mvlet e))
	    ((eq mac 'mvlet*) (host-mvlet* e))
	    ((eq mac 'step) (host-step e))
	    ((eq mac 'mulambda) (host-mulambda e))
	    ((eq mac 'sigma) (host-sigma e))
     	    ((eq mac 'hidden-delay) (host-hidden-delay e))
	    ((eq mac 'engine) (host-engine e))
	    ((eq mac 'autoload) (host-autoload e))
	    ((eq mac 'semantic-mode-reset) (host-semantic-mode-reset e)))))
	 
(defun host-let (*pattern*)
      (if (and (not (null (cadr *pattern*)))
	       (atom (cadr *pattern*)))
	  (host-iterate *pattern*)
	  (cons (cons (quote #!lambda)
		      (cons (mapcar 'car (cadr *pattern*))
			    (cddr *pattern*)))
		(mapcar 'cadr (cadr *pattern*)))))
         
(defun host-define (l)
      `(begin (#!set! ,(cadr l) ,(caddr l))
	      (quote ,(cadr l))))

(defun host-define! (l)
      `(begin (#!set! ,(cadr l) ,(caddr l))
	      (quote ,(cadr l))))

(defun host-and (*pattern*)
      (cond ((null (cdr *pattern*)) (quote true))
	    ((null (cddr *pattern*)) (cadr *pattern*))
	    (t (list (quote #!if)
		    (cadr *pattern*)
		    (cons 'and (cddr *pattern*))
		    (quote false)))))

(defun host-or (*pattern*)
      (cond ((null (cdr *pattern*)) (quote false))
	    ((null (cddr *pattern*)) (cadr *pattern*))
	    (t (let ((g (gensym)))
		  (list (list (quote #!lambda)
			      (cons g nil)
			      (list (quote #!if)
				    g
				    g
				    (cons 'or (cddr *pattern*))))
			(cadr *pattern*))))))

(defun host-rec (l)
	`((#!lambda (,(cadr l)) (#!set! ,(cadr l) ,(caddr l))) any))

(defun host-let* (*00000)
      ((lambda (tail)
	  (let ((pairs (car tail))
		(body (cdr tail)))
	     (list (cons '#!lambda
		      (cons (list (caar pairs))
			    (if (cdr pairs)
				(list
				   (cons 'let*
				      (cons (cdr pairs)
					    body)))
			        body)))
		   (cadar pairs))))
       (cdr *00000)))

(defun host-letrec (*00000)
      ((lambda (tail)
	  (let ((pairs (car tail)) (body (cdr tail)))
	     (cons (cons '#!lambda
		      (cons (mapcar 'car pairs)
			    (append (mapcar (function (lambda (x)
							 (cons '#!set! x)))
				       pairs)
			       body)))
		   (mapcar (function (lambda (x) 'any)) pairs))))
       (cdr *00000)))

(defun host-cond (e)
      (let ((e (cdr e)))
	 (cond ((null e) 'any)
	       ((and (null (cdr e)) (eq (caar e) t))
		(if (null (cdar e))
		    t
		    ((lambda (x)
			     (cond ((cdr x) (cons 'begin x))
				   (t (car x))))
		     (cdar e))))
	       ((null (cdr e))
		(let ((test (caar e))
		      (then (cdar e)))
		   (cond ((null test) 'any)
			 ((null then)
			  `((#!lambda (*00000)
			       (#!if *00000 *00000))
			    ,test))
			 (t  `(#!if ,test
				 ,((lambda (x)
				      (if (cdr x)
					  (cons 'begin x)
					  (car x)))
				   then))))))
	       (t (let ((test (caar e))
			(then (cdar e)))
		     (cond ((null test) (cons 'cond (cdr e)))
			   ((null then)
			    (let ((g (gensym)))
			       `((#!lambda (,g)
				    (#!if ,g ,g
				       ,(cons 'cond (cdr e))))
				 ,test)))
			   (t `(#!if ,test
				  ,((lambda (x)
				       (if (cdr x)
					   (cons 'begin x)
					   (car x)))
				    then)
				  ,(cons 'cond (cdr e))))))))))
    
(defun host-iterate (*pattern*)	; don't delete this without changing let
      (cons (list (list (quote #!lambda)
			(cons (cadr *pattern*) nil)
			(list (quote #!set!)
			      (cadr *pattern*)
			      (cons (quote #!lambda)
				    (cons (mapcar 'car (caddr *pattern*))
					  (cdddr *pattern*)))))
		  (quote any))
	    (mapcar 'cadr (caddr *pattern*))))

(defun host-case (*00000)
      ((lambda (*00000)
	  (let ((tag (car *00000))
		(pairs (cdr *00000)))
	     (list
		(let ((g (gensym)))
		   (list (quote lambda)
			 (list g)
			 (iterate-over pairs pairs tag g)))
		tag)))
       (cdr *00000)))

(defun host-freeze (*pattern*)
      (cons '#!lambda (cons nil (cdr *pattern*))))

(defun host-delay (*pattern*)
	`((#!lambda (proc)
		(let ((eval-ed? nil) (result nil))
		     (#!lambda ()
				(if (not eval-ed?)
				    (begin (#!set! result (proc))
					   (#!set! eval-ed t)))
				result)))
	  (#!lambda () ,*pattern*)))

(defun host-begin0 (*pattern*)
      (let ((v (gensym)))
	 (list (cons '#!lambda
		  (cons (cons v nil)
			(append (cddr *pattern*) (cons v nil))))
	       (cadr *pattern*))))

(defun host-apply-if (*pattern*)
      (let ((v (gensym)))
	 (list (list '#!lambda
		  (cons v nil)
		  (list '#!if
		     v
		     (list (caddr *pattern*) v)
		     (cons 'begin (cdddr *pattern*))))
	       (cadr *pattern*))))

(defun host-macro (*pattern*)
      (list 'begin
	 (list 'add-to-syntax-table
	    (list 'quote (cons (cadr *pattern*) nil))
	    (list '#!lambda
	       (cons 'l nil)
	       (list 'beta-tag
		  (list 'copy
		     (list (caddr *pattern*)
			   '(intern* l))))))
	 (list 'quote (cadr *pattern*))))
   
(defun host-alias (*pattern*)
      (list 'begin
	 (list 'add-to-syntax-table
	    (list 'cons
	       (list 'quote (cadr *pattern*))
               `((#!lambda (x) (if x (cdadr x) ()))
                 (getprop (quote ,(caddr *pattern*))
                          'beta-transform)))
	    (list '#!lambda
	       (cons 'l nil)
	       (list 'cons
		  (list 'quote (caddr *pattern*))
		  '(cdr l))))
	 (list 'quote (cadr *pattern*))))

(defun host-step (*pattern*)
      (list 'let
	 (mapcar (function
		    (lambda (^00028)
		       (list (car ^00028) (cadr ^00028))))
	    (cadr *pattern*))
	 (cons (list 'rec
		  '*00000
		  (list '#!lambda
		     nil
		     (list '#!if
			(car (caddr *pattern*))
			(cons 'begin (cdr (caddr *pattern*)))
			(cons 'begin
			   (append (cdddr *pattern*)
			      (append 
				 (mapcar (function
					    (lambda (^00026)
					    (list '#!set!
					       (car ^00026)
					       (list
						   (caddr ^00026)
						   (car ^00026)))))
				    (cadr *pattern*))
				 (cons (cons '*00000 nil) nil)))))))
	       nil)))

(defun new-ids (args)
    (cond
      ((consp args) (cons (gensym) (new-ids (cdr args))))
      ((null args) nil)
      (t (gensym))))

(defun identifier-list (args)
      (cond
	 ((consp args) (cons (car args) (identifier-list (cdr args))))
	 ((null args) nil)
	 (t (list args))))
   
(defun host-autoload (*pattern*)
      (list 'define
	 (cadr *pattern*)
	 (list '#!lambda
	    (caddr *pattern*)
	    (list 'load (cadddr *pattern*))
	    (list 'apply (cadr *pattern*) (caddr *pattern*)))))

(defun host-begin (*pattern*)
      (if (null (cdr *pattern*))
	  nil
	  (cons (cons '#!lambda (cons nil (cdr *pattern*))) nil)))

(defun iterate-over (p pairs tag g)
      (if p
	 (if (and (null (cdr p))
		  (eq (caar p) (quote else)))
	     (cons
		(quote begin)
		(cdar p))
	     (list
		(quote if)
		(list
		   (if (atom (caar p))
		       (quote eq?)
		       (quote memq))
		   g
		   (list
		      (quote quote)
		      (caar p)))
		(cons (quote begin)
		      (append (cdar p) (quote nil)))
		(iterate-over (cdr p) pairs tag g)))
	 (cons
	    (quote begin)
	    (cons
	       (quote (print (quote |(case |)))
	       (cons
		  (list (quote print)
			(list (quote quote) tag))
		  (cons
		     (cons (quote if)
			   (cons
			      (list (quote quote) pairs)
			      (quote ((newline)))))
		     (cons
			(list
			   (quote mapc)
			   (quote
			      (lambda (x)
				 (writeln
				    (quote |   |)
				    x)))
			   (list (quote quote) pairs))
			`((writeln (quote |)|))
			  (writeln
			     (quote
				|[case: unmatched tag: |)
			     ,g
			     (quote |]|))))))))))

(defun host-engine (*pattern*)
      (list 'make-engine (cons '#!lambda (cons nil (cdr *pattern*)))))

(defun host-lambda (*pattern*)
      (cons '#!lambda (cdr *pattern*)))

(defun host-if (*pattern*)
      (cons '#!if (cdr *pattern*)))

(defun host-set! (*pattern*)
      (cons '#!set! (cdr *pattern*)))

(defun host-mulambda (*pattern*)
      (cons '#!lambda (cdr *pattern*)))

(defun help-sigma (i new-i)
      (list '#!set! i new-i))

(defun host-sigma (*pattern*)
      (let ((new-ids (mapcar 'gensym
			     (mapcar 'symbol-name
				     (cadr *pattern*)))))
	 (cons '#!lambda
	     (cons new-ids
		 (append (mapcar 'help-sigma (cadr *pattern*) new-ids)
		    (cddr *pattern*))))))

(defun map-vars (vars body)
      (if (consp vars) 
	  (let ((v (map-vars (cdr vars) body)))
	     (let ((vvars (car v))
		   (vbody (cadr v)))
		(let ((a (make-var (car vars) vbody)))
		   (let ((avar (car a))
			 (abody (cadr a)))
		      (list (cons avar vvars)
			    abody)))))
	  (list vars body)))

(defun make-var (vars body)
      (if (consp vars)
	  (let ((p (map-vars vars body)))
		(let ((pvars (car p))
		      (pbody (cadr p)))
		   (let ((tvar (gensym "m")))
		      (list tvar 
			 `(apply (lambda ,pvars
				    ,pbody)
				 ,tvar)))))
	  (list vars body)))

(defun make-let (var-lists body)
      (if (null var-lists)
	  (list nil nil body)
	  (let ((ll (car var-lists)))
	       (if (or	(atom ll)
			(/= (length ll) 2))
		   (raise (list 'SE%mvlet '|Bad let pair:| ll))
		   (let ((vars (car ll))
			 (exp (cadr ll)))
			(let ((x (make-var vars body)))
			     (let ((xvar (car x))
				   (xbody (cadr x)))
				  (let ((y (make-let (cdr var-lists) xbody)))
				    (let ((yvars (car y))
					  (yvals (cadr y))
					  (ybody (caddr y)))
				       (list (cons xvar yvars)
					     (cons exp yvals)
					     ybody))))))))))

(defun make-let* (var-lists body)
      (if (null var-lists)
	  body
	  (let ((ll (car var-lists)))
	       (if (or (atom ll) (/= (length ll) 2))
		   (raise (list 'SE%mvlet '|Bad let pair:| ll))
		   (let ((vars (car ll))
			 (exp (cadr ll)))
			(let ((y (make-let* (cdr var-lists) body)))
			     (let ((x (make-var vars y)))
				  (let ((xvar (car x))
				       (xbody (cadr x)))
				    `((#!lambda (,xvar) 
					 ,xbody)
				      ,exp)))))))))

(defun host-mvlet (form)
      (let ((x (make-let (cadr form) (cons 'begin (cddr form)))))
	 `((lambda ,(car x) ,(caddr x))
	   . ,(cadr x))))

(defun host-mvlet* (form)
      (make-let* (cadr form) (cons 'begin (cddr form))))


(defun host-semantic-mode-reset (form)
      (set-lexical-semantics nil)
      (set-application-semantics nil)
      (set-literal-semantics nil)
      t)
