;(eval-when (compile) (proclaim '(optimize (speed 3) (safety 0) (space 2))))

(eval-when (compile load)

(proclaim '(special namespacetypes scheme-directory))
(proclaim '(special nat-log-base))
(proclaim '(special host-macs procedure-tags))
(proclaim '(special scheme-id-declared-semantics application-declared-semantics
                literal-declare-semantics ))

(defun |#!-reader| (stream subchar arg)
	(declare (ignore subchar arg))
	(car (multiple-value-list
		   (intern (concatenate 'string "#!"
					(symbol-name (read stream t nil t)))))))

(set-dispatch-macro-character #\# #\! '|#!-reader|)

(setq namespacetypes '(system-function scheme-primitive beta-transform
		       scheme-constant constant-primitive
		       constant-system-function))

(defun getl (sym props)
	(multiple-value-bind (a b c)
		(get-properties (symbol-plist sym) props)
		c))

(defun implode (x)
	(intern (coerce (mapcar (function character) x) 'string)))
(defun explode (x)
        (coerce (symbol-name x) 'list))

(defun symbol<? (sym1 sym2)
	(string< (symbol-name sym1) (symbol-name sym2)))
(defun symbol>? (sym1 sym2)
	(string> (symbol-name sym1) (symbol-name sym2)))

(defun oblist ()
	(let	((l ()))
		(do-symbols (sym (find-package 'user))
			    (setq l (cons sym l)))
		(do-external-symbols (sym (find-package 'lisp))
				     (setq l (cons sym l)))
		l))

(defmacro find-all-of-type (l)
	  `(sort (remove-if-not '(lambda (a) (get a ,l))
				(oblist))
		 'symbol<?))


(defmacro create (a b)
	`(defun ,a (id value)
		(if (atom id)
		    (let ((current (global-namespacetype id)))
			 (cond (current
				(princ "*")
				(princ id)
				(princ " already defined as a ")
				(princ current)
				(princ "*")
				(terpri)
;				(lisp-debug)
				(reset)))
			 ,(if (eq b 'scheme-primitive)
			      '(setf (get id 'scheme-primitive)
				     (if (atom value)
					 (cadr (getl value
						     '(scheme-primitive
						       constant-primitive)))
					 value))
			      `(setf (get id ',b) value))
			 id)
		    (raise (list 'SE%create
				 '|First argument must evaluate to an atom|
				 id)))))


(create create-system-function system-function)

(create create-scheme-primitive scheme-primitive)


(defun global-binding (id)
    (if (atom id)
	(prog (gb-location)
		 (cond ((setq gb-location (getl id namespacetypes))
			(return (cadr gb-location)))
		       ((setq gb-location
			  (assq id (cdr (lookupinbase 'base-environment))))
			(return (cdr gb-location)))
		       ((setq gb-location (get id 'beta-transform))
			(return (caddr gb-location)))
		       (t (raise
			    (list 'SE%global '|global-binding:|
			      '|Unbound identifier:| id)))))
	(raise (list 'SE%global '|global-binding:|
		 '|Argument must evaluate to an atom:| id))))

(defun global-namespacetype (id)
      (if (atom id)
	  (prog (gb-location)
		   (cond ((syntactic-extension? id)
			  (return 'syntactic-extension))
			 ((memq id '(quote #!lambda #!if #!set!))
			  (return 'special-form))
			 ((setq gb-location (getl id namespacetypes))
			  (return
			     (let ((name (car gb-location)))
				(cond ((eq name 'constant-primitive)
				       'constant)
				      ((eq name 'scheme-constant) 'constant)
				      ((eq name 'constant-system-function)
				       'constant)
				      (t name)))))
			 ((setq gb-location (baselocation id))
			  (return (if (eq (cdr gb-location) 'unassigned)
				      ()
				      'base-identifier)))
			 (t (return nil))))
	  (raise (list 'SE%global '|global-namespace-type:|
		     '|Argument must evaluate to an atom:| id))))

(defun syntactic-extension? (id)
      (and (symbolp id)
	   (not (null (or (get id 'beta-transform)
			  (memq id host-macs))))))

(defun scheme-constant? (id)
      (and (symbolp id)
	   (not (null (getl id '(scheme-constant constant-primitive
			       constant-system-function))))))

; function-alias allows aliasing of existing Scheme primitives and Lisp funs

(defun function-alias (newname oldname)
      (if (and (atom newname) (atom oldname))
	  (prog (type)
		   (setq type (car (getl oldname namespacetypes)))
		   (cond ((eq type 'scheme-primitive)
			  (create-scheme-primitive newname oldname))
			 ((eq type 'constant-primitive)
			  (create-scheme-primitive newname oldname)
			  (declare-constant newname))
			 ((eq type 'beta-transform)
			  (raise (list 'SE%global
				    '|function-alias:|
				    oldname
				    '|is defined as a syntactic extension|)))
			 (t (create-system-function newname oldname)))
		   (return newname))
	  (raise (list 'SE%global '|function-alias:|
			 '|Both arguments must evaluate to atoms|))))

; import makes arbitrary Common Lisp functions available to Scheme

(defun schimport (lispfunction)
      (if (atom lispfunction)
	  (function-alias lispfunction lispfunction)
	  (raise (list 'SE%global '|import:|
			 '|Illegal identifier:| lispfunction))))

(defun system-functions ()
	(sort (append (find-all-of-type 'system-function)
		      (find-all-of-type 'constant-system-function))
	      'symbol<?))

(defun scheme-primitives ()
	(sort (append (find-all-of-type 'scheme-primitive)
		      (find-all-of-type 'constant-primitive))
	      'symbol<?))

(defun symbols-bound-to-constants ()
	(sort (append (find-all-of-type 'scheme-constant)
		      (find-all-of-type 'constant-primitive)
		      (find-all-of-type 'constant-system-function))
	      'symbol<?))

(defun beta-transforms ()
	(sort (append host-macs (find-all-of-type 'beta-transform))
	      'symbol<?))

(defun top-level-assigned-identifiers ()
      (sort (append (scheme-primitives)
		    (system-functions)
		    (find-all-of-type 'scheme-constant)
		    (base-identifiers))
	    'symbol<?))

(defun remove-from-namespace (name)
      (cond ((atom name)
	     (let ((type (car (getl name namespacetypes))))
		(cond (type	(remprop name type))
		      ((memq name host-macs)
				(setq host-macs (delq name host-macs)))
		      (t	(removefrombase name)))
		(rplacd (baselocation 'defined-forms)
		   (delete (assq name (lookupinbase 'defined-forms))
		      (lookupinbase 'defined-forms))))
	     name)
	    (t (standardprint "(Argument must evaluate to an atom)")
	       (new-line schpoport)
	       (reset))))

(setq scheme-id-declared-semantics nil)
(setq application-declared-semantics nil)

(defun set-lexical-semantics (f)
	(setq scheme-id-declared-semantics f))

(defun set-application-semantics (f)
	(setq application-declared-semantics f))

(defun set-literal-semantics (f)
	(setq literal-declared-semantics f))

(defun symbol->ascii (sym)
	(char-int (character sym)))

(defun ascii->symbol (num)
	(intern (string (int-char num))))


(setq system:*ignore-eof-on-terminal-io* t)

(defun |[-reader| (stream char)
       (declare (ignore char))
       (read-delimited-list #\] stream t))
(set-macro-character #\[ #'|[-reader|)
(set-macro-character #\] (get-macro-character #\) ))

(defun |{-reader| (stream char)
       (declare (ignore char))
       (read-delimited-list #\} stream t))
(set-macro-character #\{ #'|{-reader|)
(set-macro-character #\} (get-macro-character #\) ))

(defun t-reader (stream subchar arg)
	(declare (ignore stream subchar arg))
	'|#T|)
(defun f-reader (stream subchar arg)
	(declare (ignore stream subchar arg))
	'|#F|)
(set-dispatch-macro-character #\# #\t 't-reader)
(set-dispatch-macro-character #\# #\f 'f-reader)

(defun >-reader (stream subchar arg)
       (declare (ignore stream subchar arg))
       '|#>|)
(set-dispatch-macro-character #\# #\> '>-reader)


(setq nat-log-base (exp 1))
;You get the factorial of a number
;by calling (fact n).  If you want the value of the gamma function, 
;you can call (gamma n).  The relationship between the two is 
;(gamma n) = (fact (1- n)).

(defun trfact (y)
      (trfact-help y 1.0))

(defun trfact-help (y result)
      (if (<= y 1)
	  result
	  (trfact-help (1- y) (* y result))))

(defvar gamma-list
   (list 1.0e-16
      1.4e-15
      -5.4e-15
      -2.06e-14
      5.1e-13
      -3.6968e-12
      7.7823e-12
      1.043427e-10
      -1.1812746e-9
      5.0020075e-9
      6.116095e-9
      -2.056338417e-7
      1.1330272320e-6
      -1.2504934821e-6
      -0.0000201348547807
      0.0001280502823882
      -0.0002152416741149
      -0.0011651675918591
      0.0072189432466630
      -0.0096219715278770
      -0.0421977345555443
      0.1665386113822915
      -0.0420026350340952
      -0.6558780715202538
      0.5772156649015329
      1.0))

(defun recip (y)
      (recip-help y gamma-list 0.0))

(defun recip-help (y v result)
      (if (null v)
	  result
	  (recip-help y (cdr v) (+ (* result y) (car v)))))

(defun gamma (x)
      (cond
	 ((and (zerop (- x (floor x))) (plusp x)) (trfact (1- (floor x))))
	 ((zerop (- x (floor x))) 'undefined)
	 (t (let ((y (abs x)))
	       (let ((z (- y (floor y))))
		  (let ((w (- z)))
		     (cond
			((and (> x 1)(<= z .5))
			 (/ (trfact (1- x)) (recip z)))
			((> x 1)
			 (/ (* (trfact (1- x)) z)
			    (recip (1- z))))
			((and (plusp x) (<= z .5))
			 (/ 1.0 (* (recip z) z)))
			((plusp x)
			 (/ 1.0 (recip (1- z))))
			((and (< x -1) (<= z .5))
			 (/ (expt -1.0 (floor y)) 
			    (* (trfact y) (recip w) z)))
			((< x -1)
			 (/ (expt -1.0 (floor (1+ y)))
			    (* (trfact y) w (recip (1+ w)) (1+ w))))
			((<= z .5)
			 (/ 1.0 (* (recip w) w)))
			(t (/ 1.0
			      (* (recip (1+ w)) w (1+ w)))))))))))
	   
(defun fact (x)
      (if (and (integerp x) (not (minusp x)))
	  (prog (a)
		   (setq a 1)
		  loop
		   (if (zerop x) (return a))
		   (setq a (* a x))
		   (setq x (1- x))
		   (go loop))
	  (gamma (1+ x))))

;This version of factorial is accurate to at least 15 figures for x between
;1 and 2, and it uses the formula that (fact n) = (* n (fact (1- n))) to
;get its values for larger x.  It works for all values, positive and negative
;as long as we are not at a negative integer, where factorial is undefined.
;Happy Scheming!


(defun transpose (lst)
      (let ((l (make-same-length (reverse lst))))
	   (do ((tl nil (do ((x l (cdr x))
			     (y nil (prog2 nil 
				       (cons (caar x) y)
				       (rplaca x (cdar x)))))
			    ((null x) (cons y tl)))))
	       ((null (car l)) (nreverse tl)))))

(defun make-same-length (ll)
       (if (null ll)
	   nil
	   (let ((n (apply 'min (mapcar 'length ll))))
		(if (zerop n)
		    (mapcar (function (lambda (l) nil)) ll)
		    (mapcar (function (lambda (l)
					  (progn (trim-to-length (1- n) l)
						 l)))
			    ll)))))

(defun trim-to-length (n l)
     (if (zerop n)
	 (rplacd l nil)
	 (trim-to-length (1- n) (cdr l))))

(defun make-printable (name)
    (rplacd (baselocation 'unprintables)
      (delete (assq name (lookupinbase 'unprintables))
	(lookupinbase 'unprintables)))
    name)

(defun make-unprintable (name printname)
    (cond ((null printname)
	   (raise (list 'SE%print '|make-unprintable:|
		    '|unspecified unprintable-symbol|)))
	  ((assq name (lookupinbase 'unprintables)) name)
	  (t (rplacd (baselocation 'unprintables)
	       (nconc (lookupinbase 'unprintables)
		      (list (cons name printname))))
	     name)))

(defun reify (e)
      (if (not (and (consp e) (atom (car e))))
	  nil
	  (let ((tag (car e)))
	     (cond
		((eq '&cont tag) `(continuation ,(cont-lex-env e) 
				     ,(cont-flu-env e) 
				     ,(next-frame e)))
		((eq '&closure tag) `(closure ,(clo-number-of-args e) 
					,(clo-formals e) 
					,(clo-lex-env e)))
		((eq '&rest-closure tag)
		 `(closure ,(clo-number-of-args e)
		     ,(let ((x (clo-formals e)))
			 (if (null (cdr x))
			     (car x)
			     (let ((y (copy (cdr x))))
				  (rplacd (last y) (car x))
				  y)))
		     ,(clo-lex-env e)))
		((eq '&transform tag)
		 `(beta-transform ,(keywords-list e) ,(transform-function e)))
		((eq '&sys tag) `(closure 0 x (&lexical-env nil)))
		((eq '&engine tag) `(engine 3 (x y z) 
				       ,(continuation-of-engine e)))
		((eq '&state tag) `(state 0 () ,(continuation-of-engine e)))
		((eq '&in-port tag) `(input-port ,(file-name-of-port e)))
		((eq '&out-port tag) `(output-port ,(file-name-of-port e)))
		((eq '&closed-port tag) `(closed-port ,(file-name-of-port e)))
		((eq '&lexical-env tag) `(lexical-environment
					    ,(lex-ids e)
					    ,(lex-vals e)
					    ,(next-lexical-env e)))
		(t nil)))))
	     
(defun cont-lex-env (e)
      (let ((cont (cdr e)))
           (let ((frame (car cont)))
	        `(&lexical-env ,(caddr frame)))))

(defun next-frame (e)
      (let ((cont (cdr e)))
	   (if (null (cdr cont))
	       nil
	       `(&cont ,(cdr cont)))))

(defun clo-number-of-args (e)
      (let ((obj (cdr e)))
	   (caar obj)))

(defun clo-formals (e)
      (let ((obj (cdr e)))
	   (cadar obj)))

(defun clo-lex-env (e)
      (let ((obj (cdr e)))
	   `(&lexical-env ,(cdr obj))))

(defun continuation-of-engine (e)
      (let ((obj (cdr e)))
	   `(&cont ,(car obj))))

(defun file-name-of-port (e)
      (let ((obj (cdr e)))
	   (car obj)))

(defun lex-ids (e)
      (let ((obj (cadr e)))
	   (cdar obj)))

(defun lex-vals (e)
      (let ((obj (cadr e)))
	   (caar obj)))

(defun next-lexical-env (e)
      (let ((obj (cadr e)))
	   (if (null (cdr obj))
	       nil
	       `(&lexical-env ,(cdr obj)))))

(defun keywords-list (e)
	(cadr e))

(defun transform-function (e)
	(caddr e))

(setq procedure-tags 
   '(&closure &sys &cont &engine &rest-closure &transform &vector &state))

(defun proc? (a)
      (and (consp a)
	   (memq (car a) procedure-tags)
	   t))

(defun quotient (x y)	; integer division
	(truncate (float (/ x y))))
;	(/ (- x (mod x y)) y))

(defun concat (&rest x)
        (apply 'concatenate (cons 'string x)))
)
