(def if
  (macro (l)
	 (cond ((eq (length l) 3) `(cond (,(cadr l) ,(caddr l))))
	       ((eq (length l) 4) `(cond (,(cadr l) ,(caddr l))
					 (t ,(cadddr l)))))))

(def genbase (lambda () (cons '&base nil)))

(def extendbase
  (lambda (i v)
    (rplacd *init-base* (cons (cons i v) (cdr *init-base*)))))
    
(def removefrombase
  (lambda (i)
    (let ((pr (assq i (cdr (setq tempbase *init-base*)))))
      (cond
	((null pr) nil)
	(t (rplacd tempbase (delete pr (cdr tempbase))))))))

(def base-identifiers (lambda () (mapcar 'car (cdr *init-base*))))

(def lookupinbase
  (lambda (i)
    (let ([pr (baselocation i)])
      (cond
	[(eq (cdr pr) 'unassigned)
	 (raise (list 'SE%base 0 t '|Unbound base identifier:| i))]
	[t (cdr pr)]))))	 

(def baselocation (lambda (i) (assq i (cdr *init-base*))))

(def guaranteedlookup
  (lambda (id)
    (let ([pr (baselocation id)])
      (cond
	[pr pr]
	[t (extendbase id 'unassigned)
	   (baselocation id)]))))
	
	      
(def scheme-reset
  (lambda ()
    (rplacd 
      (baselocation 'scheme-top-level)
      (global-binding 'global-scheme-top-level))
    (reset)))
