; -*- Mode: Scheme; Syntax: Scheme; Package: Scheme; -*-
; File utils.scm / Copyright (c) 1989 Jonathan Rees / See file COPYING

;;;; Miscellaneous general and not-so-general utilities

; posq

(define (vector-posq thing v)
  (lisp:position thing (lisp:the lisp:simple-vector v)))

(define (string-posq c s)
  (lisp:position c (lisp:the lisp:simple-string s)))

; Fluids

(define (make-fluid top-level-value)
  (let ((f (lisp:gensym "FLUID")))
    (lisp:set f top-level-value)
    f))

(define (fluid f)
  (lisp:symbol-value f))

(define (set-fluid! f val)
  (lisp:set f val))

(define (let-fluid f val thunk)
  (lisp:progv (list f) (list val) (thunk)))

; Tables

(define (make-table)
  ;; Default size in VAX LISP is 71, which seems rather large.
  (lisp:values (lisp:make-hash-table :size 20 :rehash-size 2.0)))

(define (table-set! table key val)
  (lisp:setf (lisp:gethash key table) val))

(define (table-ref table key)
  (lisp:gethash key table #f))

; Pretty-printer used by translator
; Two cases:
;  - If package is scheme-package, then unqualified symbols must print
;    without package prefixes, and qualified ones must print with.
;  - Otherwise, the opposite, and the package prefix for unqualified
;    symbols ought to be 

(define cl-readtable (lisp:copy-readtable nil))

(lisp:defun write-pretty (form port package)
  (lisp:let ((lisp:*package* package)
	     (lisp:*readtable* cl-readtable))
    (lisp:declare (lisp:special cl-readtable))
    (lisp:format port "~&")
    (lisp:write form :stream port
		     :pretty t
		     :length nil
		     :level nil)
    (lisp:values)))

; Package stuff, etc.

; These things are needed by the runtime system, too, BEFORE the
; translator can be loaded.  Maybe the code should just be replicated?

(define environment-marker      #'scheme-hacks:environment-marker)
(define intern-renaming-perhaps #'scheme-hacks:intern-renaming-perhaps)

(define qualified-symbol? #'scheme-hacks:qualified-symbol?)

(define make-photon #'scheme-hacks:make-photon)

; namestring
; truename
; merge-pathnames
; make-pathname
; package-name

(define (scheme-implementation-version)
  (string-append (lisp:lisp-implementation-type)
		 " "
		 (lisp:lisp-implementation-version)))
