; TOPLEVEL.S
;************************************************************************
;*									*
;*		PC Scheme/Geneva 4.00 Scheme code			*
;*									*
;* (c) 1985-1988 by Texas Instruments, Inc. See COPYRIGHT.TXT		*
;* (c) 1992 by L. Bartholdi & M. Vuilleumier, University of Geneva	*
;*									*
;*----------------------------------------------------------------------*
;*									*
;*		Standard Scheme Top-Level Routines			*
;*									*
;*----------------------------------------------------------------------*
;*									*
;* Created by: David Bartley		Date: 1985			*
;* Revision history:							*
;* - 1 Jun 87:	modified runtime-system toplevel handling so it works	*
;*		identically to the compiler version; this gets rid of	*
;*		APPLICATION-TOP-LEVEL, and PATCH.PCS and .INI handling	*
;*		will get executed in the runtime system	(rb)		*
;* - 18 Jun 92:	Renaissance (Borland Compilers, ...)			*
;*									*
;*					``In nomine omnipotentii dei''	*
;************************************************************************

(begin
  (define reset-scheme-top-level				; SCHEME-TOP-LEVEL
    (let ((saved-genv user-initial-environment))
      (lambda ()
	(letrec
	 ((==reset== '())
	  (==scheme-reset==			; here for SCHEME-RESET
	   (lambda ()
	     (%set-global-environment saved-genv)
	     (set! (fluid input-port) standard-input)
	     (set! (fluid output-port) standard-output)
	     (putprop '%PCS-STL-HISTORY (list '()) %pcs-stl-history)
;	     (full-screen)
	     (newline)
	     (display "[PCS-DEBUG-MODE is ")
	     (display (if pcs-debug-mode "ON" "OFF"))
	     (if pcs-machine-type
		 (let ((cpu (caar pcs-machine-type))
		       (ndp (cadr pcs-machine-type)))
		   (display ", machine is 80") (display cpu)
		   (display " at ") (display (cdar pcs-machine-type))
		   (display " MHz with ")
		   (display (if (= ndp 0) "no" (if (= cpu 486) "built-in"
			      (begin (display "80") ndp))))
		   (display " coprocessor")))
	     (display "]")
	     (newline)
	     (call/cc (lambda (k)
			(set! ==reset== (lambda ()(k '())))
			(set! (fluid scheme-top-level)
			      ==reset==)))
						; here for RESET (if fluid
						; SCHEME-TOP-LEVEL hasn't been redefined;
						; if it has, restart that function)
	     (pcs-kill-engine)
	     (gc)			; restore WHO line  (temporary)
	     (more)))
	  (more
	   (lambda ()
	     (pcs-clear-registers)
	     (fresh-line)
	     (display "[")
	     (display (length (getprop '%PCS-STL-HISTORY %pcs-stl-history)))
	     (display "] ")
	     (if (member 'gc %pcs-stl-debug-flag) (gc #T))
	     (let ((problem (read)))
	       (flush-input)
	       (if (eof-object? problem)
		   (display "[End of file read by SCHEME-TOP-LEVEL]")
		   (begin
		     (putprop '%PCS-STL-HISTORY
			      (cons (list problem)
				    (getprop '%PCS-STL-HISTORY
					     %pcs-stl-history))
			      %pcs-stl-history)
		     (let* ((answer (eval (if (member 'debug %pcs-stl-debug-flag)
					      (compile (list 'BEGIN
							 '(%BEGIN-DEBUG)
							 problem))
					      problem)))
			    (next (fluid scheme-top-level)))
		       (when (not (eq? answer *the-non-printing-object*))
			     (write answer))
		       (putprop '%PCS-STL-HISTORY
				(cons (cons problem answer)
				      (cdr (getprop '%PCS-STL-HISTORY
						    %pcs-stl-history)))
				%pcs-stl-history)
		       (if (eq? next ==reset==)
			   (more)
			   (next)))))))))
	 (set! (fluid scheme-top-level) ==scheme-reset==)
	 *the-non-printing-object*))))

  ; %C accesses the nth user command
  ; %D accesses the result of the nth user command

  (define %c						; %C
    (lambda (n)
      (let ((history (getprop '%PCS-STL-HISTORY %pcs-stl-history)))
	(and (positive? n)
	     (< n (length history))
	     (car (list-ref (reverse history) n))))))

  (define %d						; %D
    (lambda (n)
      (let ((history (getprop '%PCS-STL-HISTORY %pcs-stl-history)))
	(and (positive? n)
	     (< n (length history))
	     (cdr (list-ref (reverse history) n))))))
) ;begin

(reset-scheme-top-level)

(let ((file (%system-file-name "PATCH.PCS")))
  (when (file-exists? file)			 ; system patches
	(load file)))


;; Pathnames read as text from a file will have single backslashes.
;; This doubles them so a read-from-string type operation will work on them.
;; It's used for the .INI processing following.
(define (double-slashify string)
  (let loop ((m 0)
	     (n 0)
	     (new (make-string (string-length string) '())))
    (if (= m (string-length string))
	new
	(begin
	  (string-set! new n (string-ref string m))
	  (if (char=? (string-ref string m) #\\)
	      (let ((newer (make-string (add1 (string-length new)) '())))
		(substring-move-left! new 0 (+ n 1) newer 0)
		(string-set! newer (+ n 1) #\\)
		(loop (+ m 1) (+ n 2) newer))
	      (loop (+ m 1) (+ n 1) new))))))


;; Now come the dos-key history management utilities...
(define (push-history item)
  (cond
    ((null? item) '())
    ((atom? item) (%push-history item))
    (else (push-history (cdr item))
          (push-history (car item)))))

(define (get-history)
  (letrec
    ((loop (lambda (n)
             (let ((item (%get-history n)))
               (if (string? item) (cons item (loop (1+ n))))))))
    (loop 0)))

(%set-global-environment user-initial-environment)


;; Note:  You can make your own toplevel function the system's toplevel by
;; assigning it to the fluid variable SCHEME-TOP-LEVEL from the .INI file.
;; Don't invoke it yourself.  After loading the .INI file, this file's
;; final SCHEME-RESET initializes the VM for toplevel recovery
;; (in case of errors) and invokes the toplevel function automatically.


(cond ((null? pcs-initial-arguments)	      ;no args at all, use scheme.ini
       (when (file-exists? "scheme.ini")
	     (load "scheme.ini")))
      (else
	(let ((pia-files
		(map symbol->string
		     (let ((x (read (open-input-string
				      (double-slashify (car pcs-initial-arguments))))))
		       (if (pair? x) x (list x))))))	;handle nonlist file
	  (let loop ((rest pia-files) (ini-files '()))  ;handle list files
	    (let ((f (car rest)))
	      (cond ((null? rest)
		     (when (null? ini-files)	    ;no ini's given, use scheme.ini
			   (set! ini-files '("scheme.ini")))
		     (for-each		    ;load several ini's
		       (lambda (f)
			 (when (file-exists? f) (load f)))
		       ini-files))
		    ((< (string-length f) 4)	    ;file sans extension--assumed ini
		     (loop (cdr rest) (cons f ini-files)))
		    ((substring-ci=? f (- (string-length f) 4) (string-length f)
				     ".app" 0 4)
		     (loop (cdr rest) ini-files))  ;don't reload compiler
		    (else
		      (loop (cdr rest) (cons f ini-files))) ;assume fasl file
		    ))))))


(scheme-reset)		; must be last operation!
