; MATH.S
;************************************************************************
;*									*
;*		PC Scheme/Geneva 4.00 Scheme code			*
;*									*
;* (c) 1985-1988 by Texas Instruments, Inc. See COPYRIGHT.TXT		*
;* (c) 1992 by L. Bartholdi & M. Vuilleumier, University of Geneva	*
;*									*
;*----------------------------------------------------------------------*
;*									*
;*	Extended Arithmetic Routines using Borland C 80x87 & Emulator	*
;*		Interface done through %escape dispatcher		*
;*									*
;*----------------------------------------------------------------------*
;*									*
;* Created by: M. Vuilleumier		Date: Jun 1992			*
;* Revision history:							*
;* - 1987:	first steps by Bob Real					*
;* - 18 Jun 92:	Renaissance (Borland Compilers, ...)			*
;*									*
;*					``In nomine omnipotentii dei''	*
;************************************************************************

(define exact? integer?)
(define inexact? float?)

(begin
  (define acos)
  (define asin)
  (define atan)
  (define cos)
  (define exp)
  (define expt)
  (define log)
  (define sin)
  (define sqrt)
  (define tan)
  (define pi)
)

(letrec
  ((%bad-argument
     (lambda (name arg)
       (%error-invalid-operand name arg)))

   (test-escape
     (lambda (name numb)
       (lambda (x)
         (if (not (number? x))
             (%bad-argument name x)
             (%esc numb (float x))))))

   (power-loop
     (lambda (x n a)      ; A is initially 1, N is non-negative
       (if (zero? n)
           a
           (power-loop (* x x)
                       (quotient n 2)
                       (if (odd? n) (* a x) a)))))
  )
  (begin
    (set! sqrt
          (lambda (n)
	    (define try ((test-escape 'sqrt 23) n))
	    (define (iter v)
	      (cond ((= (* v v) n) v)
		    ((and (< (* v v) n)
			  (> (* (+ v 1) (+ v 1)) n))
                     try)
		    (else (iter (quotient (+ v (quotient n v)) 2)))))
              (if (float? n)
	          try
		  (iter (round try)))))

    (set! sin (test-escape 'sin 24))
    (set! cos (test-escape 'cos 25))
    (set! tan (test-escape 'tan 26))
    (set! atan
          (lambda (x . z)
            (cond ((not (number? x))
                   (%bad-argument 'atan x))
                  ((null? z)
                   (%esc 27 (float x)))
                  ((not (number? (car z)))
                   (%bad-argument 'atan z))
                  (else
                    (%esc 27 (float x) (float (car z)))))))

    (set! acos (test-escape 'acos 28))
    (set! asin (test-escape 'asin 29))
    (set! log
          (lambda (x . base)
            (cond ((or (not (number? x)) (<= x 0))
                   (%bad-argument 'log x))
                  ((null? base)
                   (%esc 30 (float x)))
                  ((eq? (car base) 10)             ;the eq? is deliberate
                   (%esc 31 (float x)))
                  (else
                    (let ((non-e-base (car base)))
                      (if (not (number? non-e-base))
                          (%bad-argument 'log non-e-base)
                          (%esc 32 (float x) (float non-e-base))))))))

    (set! exp (test-escape 'exp 33))
    (set! expt
          (lambda (a x)
            (cond ((not (number? a))
                   (%bad-argument 'EXPT a))
                  ((not (number? x))
                   (%bad-argument 'EXPT x))
                  ((and (zero? a) (zero? x) (not (integer? x)))
                   (%bad-argument 'EXPT x))
                  ((zero? x)  (if (integer? a) 1 1.0))
                  ((and (integer? x) 
                        (positive? x)
                        (integer? a)) (power-loop a x 1))
                  (else
                   (%esc 34 (float a) (float x))))))

    (set! pi (acos -1))
  ))
