; ERRHAND.S
;************************************************************************
;*									*
;*		PC Scheme/Geneva 4.00 Scheme code			*
;*									*
;* (c) 1985-1988 by Texas Instruments, Inc. See COPYRIGHT.TXT		*
;* (c) 1992 by L. Bartholdi & M. Vuilleumier, University of Geneva	*
;*									*
;*----------------------------------------------------------------------*
;*									*
;*			IO Error handlers				*
;*									*
;*----------------------------------------------------------------------*
;*									*
;* Created by: David Bartley		Date: Oct 1985			*
;* Revision history:							*
;* - 18 Jun 92:	Renaissance (Borland Compilers, ...)			*
;* - 09 Jan 93: Generalized method; now support all IO primitives	*
;*									*
;*					``In nomine omnipotentii dei''	*
;************************************************************************
;
; The following code is an example of an error handler for I/O errors. The
; function open-input-file attempts to open filename for input. Note that 
; a continuation is saved in the fluid variable my%ioerr before the call to 
; open-input-file. Upon return from the open, the variable port is 
; interrogated to determine the status- To retry the operation with the same 
; filename, retry the operation with a different filename, or return the port
; object. 
;

(define (io-error-handler proc)
  (named-lambda (this-proc . args)
    (let ((port (call/cc
                  (fluid-lambda (my%ioerr) 
            	    (apply proc args)))))
      (cond ((eq? port 'retry) (apply this-proc args))
            ((string? port)    (apply this-proc port))
            (else              port)))))

(syntax (handle-io-errors proc)
	(set! (access proc user-global-environment)
	      (io-error-handler (access proc user-global-environment))))

(begin
  (handle-io-errors open-input-file)
  (handle-io-errors open-binary-input-file)
  (handle-io-errors open-output-file)
  (handle-io-errors open-binary-output-file)
  (handle-io-errors open-extend-file)
  (handle-io-errors load))

;          
; *USER-ERROR-HANDLER* has been designed to trap on all I/O errors, pop up a 
; window to indicate the error, and illicit a response from the user. The 
; result is then returned via the continuation bound to the fluid variable 
; my%ioerr. The system error handler is called for all other errors.
;
; See the User's Guide for a discussion on user error handling and a list of 
; all I/O errors.
;

(set! (access *user-error-handler* user-global-environment)
      (lambda (error-num error-msg irritant sys-error-handler)
        (if (and (fluid-bound? my%ioerr)
		 (number? error-num)
                 (>= error-num 1)
                 (<= error-num 88))
            (let ((win (make-window error-msg #T))
                  (result '())
		  (csize (window-get-size 'console)))
              (window-set-position! win (- (quotient (car csize) 2) 3) 
					(- (quotient (cdr csize) 2) 20))
              (window-set-size! win 6 40)
              (window-set-cursor! win 2 5)
	      (window-set-attribute! win 'border-attributes 28)
	      (window-set-attribute! win 'text-attributes 30)
              (window-popup win)
              (case error-num
                ((2 3)                           ;file/path not found
                 (display "File/Path not found : " win)
		 (newline win)
                 (display irritant win)
                 (newline win)
                 (newline win)
                 (display "Enter new pathame (return to exit)" win)
		 (newline win)
                 (set! result (read-line win))
                 (if (string=? result "")
                     (set! result '())))
                ((21)                           ;drive not ready
                 (display "Drive not ready - Retry (y/n) ?" win)
                 (set! result 
                       (if (char=? (char-upcase (read-char win)) #\Y)
                           'retry
                           '())))
                (else
                  (display "Extended Dos I/O Error - " win)
                  (newline win)
                  (display irritant win) 
                  (newline win)
                  (newline win)
                  (char-upcase (read-char win))
                  (set! result '())))

              (window-popup-delete win)
	      ((fluid my%ioerr) result))
	;else
            (sys-error-handler))))

