;* SPROPRTY.ASM
;************************************************************************
;*									*
;*		PC Scheme/Geneva 4.00 Borland TASM code			*
;*									*
;* (c) 1985-1988 by Texas Instruments, Inc. See COPYRIGHT.TXT		*
;* (c) 1992 by L. Bartholdi & M. Vuilleumier, University of Geneva	*
;*									*
;*----------------------------------------------------------------------*
;*									*
;*			Property management				*
;*									*
;*----------------------------------------------------------------------*
;*									*
;* Created by: John Jensen		Date: 1985			*
;* Revision history:							*
;* - 18 Jun 92:	Renaissance (Borland Compilers, ...)			*
;*									*
;*					``In nomine omnipotentii dei''	*
;************************************************************************
IDEAL
%PAGESIZE	60, 132
MODEL	medium
LOCALS	@@

	INCLUDE	"scheme.ash"

CODESEG
;************************************************************************
;*		Search for Property in Property List			*
;*									*
;* Calling Sequence:	found? = prop_search(list,prop);		*
;*									*
;* Input Parameters:	list - the property list for a symbol.		*
;*			prop - the property for which to search.	*
;*									*
;* Output Parameters:	found? - if the property was found in the list,	*
;*			found?=1; else found?=0.			*
;*			list - a pointer to the property/value pair	*
;*			for the specified property. If not found, NIL.	*
;*									*
;* Note: This routine is an assembly language version of the following	*
;* C source:								*
;* prop_search(list, prop)						*
;* int list[2],prop[2];							*
;* {									*
;*	int search[2];	/* current search entry in list */		*
;*	int temp[2];		/* temporary "register" */		*
;*	ENTER(prop_search);						*
;*									*
;*	mov_reg(search, list);						*
;*	take_cdr(search);						*
;*	while(search[rPAGE])						*
;*	{								*
;*		mov_reg(temp, search);					*
;*		take_car(temp);						*
;*		if (eq(temp,prop))					*
;*		{							*
;*			mov_reg(list, search);				*
;*			return(FOUND);					*
;*		}							*
;*	take_cddr(search);						*
;*	} /* end:		while(search[rPAGE]) */			*
;*	return(NOT_FOUND);						*
;* } /* end of function:		prop_search(list, prop) */	*
;************************************************************************
PROC C	prop_search USES si di, @@list:word, @@prop:word
	mov	bx, [@@prop]		; Load up the property into cl:dx
	mov	cl, [(REG bx).bpage]
	mov	dx, [(REG bx).disp]
	mov	si, [@@list]		; Load up a pointer to the beginning of the property list
	xor	bx, bx
	mov	bl, [(REG si).bpage]
	mov	di, [(REG si).disp]
	jmp	@@start
@@didntmatch:
	mov	bl, [(LISTDEF es:di).cdr.page]
	mov	di, [(LISTDEF es:di).cdr.disp]
@@start:
	cmp	bl, 0
	je	@@notfound
	cmp	[ptype+bx], LISTTYPE
	jne	@@notfound
	ldpage	es, bx
	mov	bl, [(LISTDEF es:di).cdr.page]
	mov	di, [(LISTDEF es:di).cdr.disp]
	cmp	bl, 0			; Test for valid list cell
	je	@@notfound
	cmp	[ptype+bx], LISTTYPE
	jne	@@notfound
	ldpage	es, bx
	cmp	dx, [(LISTDEF es:di).car.disp]
	jne	@@didntmatch
	cmp	cl, [(LISTDEF es:di).car.page]
	jne	@@didntmatch
	mov	[(REG si).bpage], bl ; move pointer to property entry
	mov	[(REG si).disp], di ; into the "list" operand register
	mov	ax, 1			; indicate property found
	ret
@@notfound:
	xor	ax, ax			; indicate no match found
	ret
ENDP	prop_search

;************************************************************************
;*		Search for Symbol in Property List			*
;*									*
;* Calling Sequence:	sym_search(sym)					*
;*									*
;* Input Parameters:	sym - a register containing a symbol who's	*
;*			property list is to be located.			*
;*									*
;* Output Parameters:	sym - the register is updated to point to the	*
;*			property list for the symbol. If no property	*
;*			list exists, it is set to NIL.			*
;*									*
;* Note: This routine is an assembly language version of the following	*
;* C source:								*
;* sym_search(sym)							*
;* int sym[2];								*
;* {									*
;*	int hash_value;			/* symbol's hash value */	*
;*	int sym_save[2];		/* initial value of symbol argument */*
;*	int temp[2];			/* temporary "register" */	*
;*	ENTER(sym_search);						*
;*									*
;*	if (ptype[CORRPAGE(sym[rPAGE])] == SYMBTYPE)			*
;*	{								*
;*	/* save symbol's page and displacement for testing purposes */	*
;*		mov_reg(sym_save, sym);					*
;*									*
;*		/* obtain hash chain to search */			*
;*		hash_value = sym_hash(sym);				*
;*		sym[rPAGE] = prop_page[hash_value];			*
;*		sym[rDISP] = prop_disp[hash_value];			*
;*									*
;*		while(sym[rPAGE])					*
;*		{							*
;*			mov_reg(temp, sym);				*
;*			take_caar(temp);				*
;*			if (eq(temp, sym_save))				*
;*			{						*
;*	/* symbol found-- return pointer to symbol's property list */	*
;*				take_car(sym);				*
;*				break;					*
;*			}						*
;*			else						*
;*			{						*
;*				take_cdr(sym);				*
;*			}						*
;*		} /* end:		while(sym[rPAGE]) */		*
;*	}								*
;* } /* end of function:		sym_search(sym) */		*
;************************************************************************
PROC C	sym_search USES si di, @@symbol:word
	mov	si, [@@symbol]
	mov	bx, [(REG si).page]
	cmp	[ptype+bx], SYMBTYPE
	je	@@continue
	jmp	@@notfound
@@continue:
	mov	si, [(REG si).disp]
	ldpage	es, bx
	mov	cx, bx			; copy the symbol into cl:dx
	mov	dx, si
	mov	bl, [(SYMDEF es:si).hashkey]
	mov	di, bx			; copy hash key into di and
	shl	di, 1			; multiply by two for word index
	mov	bl, [prop_page+bx]	; load property list header for this
	mov	di, [prop_disp+di]	; symbol's bucket
	jmp	@@start
@@nextreload:
	mov	bx, ax
	ldpage	es, bx
@@next:
	mov	bl, [(LISTDEF es:di).cdr.page] ; load pointer to next bucket entry
	mov	di, [(LISTDEF es:di).cdr.disp]
@@start:
	cmp	bl, 0			; end of bucket?
	je	@@notfound
	cmp	[ptype+bx], LISTTYPE
	jne	@@notfound
	ldpage	es, bx
	mov	ax, bx			; Save Bucket entry page number
	mov	bl, [(LISTDEF es:di).car.page] ; Fetch prop. from the CAR field of the bucket entry
	mov	si, [(LISTDEF es:di).car.disp]
	cmp	bl, 0			; no property list for this bucket entry?
	je	@@next
	cmp	[ptype+bx], LISTTYPE
	jne	@@next
	ldpage	es, bx
	cmp	dx, [(LISTDEF es:si).car.disp]
	jne	@@nextreload
	cmp	cl, [(LISTDEF es:si).car.page]
	jne	@@nextreload
	mov	di, [@@symbol]
	mov	[(REG di).bpage], bl ; store prop list pointer into reg
	mov	[(REG di).disp], si
	ret
@@notfound:
	xor	ax, ax		; create a NIL pointer
	mov	di, [@@symbol]
	mov	[(REG di).bpage], al
	mov	[(REG di).disp], ax
	ret
ENDP	sym_search

	END
