;* CONS.ASM
;************************************************************************
;*									*
;*		PC Scheme/Geneva 4.00 Borland TASM code			*
;*									*
;* (c) 1985-1988 by Texas Instruments, Inc. See COPYRIGHT.TXT		*
;* (c) 1992 by L. Bartholdi & M. Vuilleumier, University of Geneva	*
;*									*
;*----------------------------------------------------------------------*
;*									*
;*			Support for Cons 				*
;*									*
;*----------------------------------------------------------------------*
;*									*
;* Created by: John Jensen		Date: 1985			*
;* Revision history:							*
;* - 18 Jun 92:	Renaissance (Borland Compilers, ...)			*
;*									*
;*					``In nomine omnipotentii dei''	*
;************************************************************************
IDEAL
%PAGESIZE	60, 132
MODEL	medium
LOCALS	@@

	INCLUDE	"scheme.ash"

CODESEG

;************************************************************************
;*									*
;*     CONS Support -- combine two pointers in a new list cell		*
;*			use: cons(result, car, cdr)			*
;*									*
;************************************************************************
PROC C 	cons	USES si di, @@result:word, @@car:word, @@cdr:word
	LOCAL	newreg:REG			      
	mov	bx, [listpage]		; Attempt a "short circuit" allocation
	shl	bx, 1
	mov	si, [nextcell+bx] 	; load next available cell offset
	cmp	si, END_LIST
	jne	@@available

	lea	ax, [newreg]		; no list cell immediately available
	call	alloc_list_cell C, ax
	mov	bx, [newreg.page]
	mov	si, [newreg.disp]
	ldpage	es, bx			; new cell at es:si
	jmp	@@startcons

@@available:
	ldpage	es, bx
	mov	ax, [(FREELISTDEF es:si).next]
	mov	[nextcell+bx], ax 	;  and update free cell chain header

@@startcons:
	mov	di, [@@cdr]   		; store CDR value into list cell
	mov	al, [(REG di).bpage]
	mov	[(LISTDEF es:si).cdr.page], al
	mov	ax, [(REG di).disp]
	mov	[(LISTDEF es:si).cdr.disp], ax

	mov	di, [@@car]		; store CAR value into list cell
	mov	al, [(REG di).bpage]
	mov	[(LISTDEF es:si).car.page], al
	mov	ax, [(REG di).disp]
	mov	[(LISTDEF es:si).car.disp], ax

	mov	di, [@@result]		; store ptr to new list cell in dest
	mov	[(REG di).page], bx
	mov	[(REG di).disp], si
	ret

ENDP	cons

	END
