;* BID.ASM
;************************************************************************
;*									*
;*		PC Scheme/Geneva 4.00 Borland TASM code			*
;*									*
;* (c) 1985-1988 by Texas Instruments, Inc. See COPYRIGHT.TXT		*
;* (c) 1992 by L. Bartholdi & M. Vuilleumier, University of Geneva	*
;*									*
;*----------------------------------------------------------------------*
;*									*
;*				Bid a task				*
;*									*
;*----------------------------------------------------------------------*
;*									*
;* Created by: John Jensen		Date: 1985			*
;* Revision history:							*
;* - 18 Jun 92:	Renaissance (Borland Compilers, ...)			*
;*									*
;*					``In nomine omnipotentii dei''	*
;************************************************************************
IDEAL
%PAGESIZE	60, 132
MODEL	medium
LOCALS	@@

	INCLUDE "scheme.ash"

MODIFMEM	= 04ah 			; Modify allocated memory function id
BIDTASK		= 04b00h		; Load and execute program function id
GETRETCODE	= 04dh			; Get program's return code
CREATE_FL	= 3ch 			; Create file function
OPEN_FL		= 3dh 			; Open file function
CLOSE_FL	= 3eh 			; Close file function
READ_FL		= 3fh 			; Read file function
WRITE_FL	= 40h 			; Write file function
DELETE_FL	= 41h 			; Delete file function
GET_DRIVE	= 19h 			; Current disk function
SET_DRIVE	= 0eh 			; Select disk function
GET_DIR		= 47h 			; Return text of current directory function
SET_DIR		= 3bh 			; Change the current directory function
NEW_FILE	= 5ah			; Create unique filename
MAXPATHLEN	= 64+13
WRITEBATCH	= 0fffh
	 
DATASEG
	EXTRN	C _psp:word

tmpfile	DB	"?:\", MAXPATHLEN dup(?)
comspec	DB	"COMSPEC="
LENCOMSPEC = $-comspec

UDATASEG
LABEL	paramblk
envptr	DW	?
cmdptr	DD	?
fcb1	DD	?
fcb2	DD	?

STRUC	XMSBLOCK
len	dd	?
shandle	dw	?
soff	dd	?
dhandle	dw	?
doff	dd	?
ENDS	XMSBLOCK

CODESEG
;************************************************************************
;*			     Bid another Task				*
;************************************************************************
;
;  Paragraph Addresses
;
;   lastparagraph  --> +--------------------+  <----
;		       |   /|\		    |	 :  Freed for bidded task,
;		       |    |		    |	 :  Saved to disk save file
;		       |    | -- free_req   |	 :   start:   lastparagraph - free_req
;		       |    |		    |	 :   length:  free_req
;		       |   \|/		    |	 :    (free_req >= lastparagraph - first_dos)
;		       |~~~~~~~~~~~~~~~~~~~~|  <----
;		       |		    |	 :
;		       |      (heap)	    |	 :  Allocated to stay resident
;		       |		    |	 :   # paras:  lastparagraph -
;  firstparagraph  --> +--------------------+	 :		 _psp -
;		       |   (unused area)    |	 :	      free_req
;	 first_dos --> +--------------------+	 :
;		       |		    |	 :
;		       |      (PCS)	    |	 :
;		       |		    |	 :
;		       |		    |	 :
;	     _psp  --> +--------------------+  <----
;		       |		    |
;
	 
PROC	delete	near 			; Deletes the save file
	lea	dx, [tmpfile] 
	mov	ah, DELETE_FL 
	int	MSDOS 
	ret	
ENDP	

PROC C	bid_task USES si di, @@file, @@param, @@freereq
	LOCAL	@@xmsaddr:DWORD, @@xmsblock:XMSBLOCK
					; Check if requested # of free paragraphs within bounds
	cmp	[@@freereq], 0 		; default to free max?
	je	@@freeall
	mov	ax, [paragraphnum] 	; compute requested base of free area
	sub	ax, [@@freereq] 	; request greater than all memory?
	jb	@@freeall
	cmp	ax, [first_dos]		; below base of free-able area?
	jnb	@@requestok
@@freeall:
	mov	ax, [paragraphnum] 	; compute max # of free-able paras
	sub	ax, [first_dos]
	mov	[@@freereq], ax
@@requestok:				; Save Scheme's user memory
	mov	ax, 4300h		; try to use XMS
	int	2fh
	cmp	al, 80h
	jne	@@swap2disk
	mov	ax, 4310h
	int	2fh
	mov	[WORD HIGH @@xmsaddr], es
	mov	[WORD LOW @@xmsaddr], bx
	mov	ah, 09h			; allocate XMS block
	mov	dx, [@@freereq]
	add	dx, 3fh			; round paragraphs up to kb above
	mov	cl, 6
	shr	dx, cl
	call	[@@xmsaddr]
	or	ax, ax
	jz	@@swap2disk
	lea	si, [@@xmsblock]
	xor	ax, ax
	mov	[(XMSBLOCK si).shandle], ax ; conventional...
	mov	[(XMSBLOCK si).dhandle], dx ; ...to extended
	mov	[WORD LOW (XMSBLOCK si).soff], ax
	mov	dx, [paragraphnum]
	sub	dx, [@@freereq]
	mov	[WORD HIGH (XMSBLOCK si).soff], dx
	mov	[WORD LOW (XMSBLOCK si).doff], ax
	mov	[WORD HIGH (XMSBLOCK si).doff], ax
	mov	bx, [@@freereq]
	mov	cx, 4
@@loop:
	shl	bx, 1
	rcl	ax, 1
	loop	@@loop
	mov	[WORD LOW (XMSBLOCK si).len], bx
	mov	[WORD HIGH (XMSBLOCK si).len], ax
	mov	ah, 0bh			; move memory block
	call	[@@xmsaddr]
	jmp	@@closeok

@@swap2disk:
	mov	[WORD LOW @@xmsaddr], -1
	mov	ah, GET_DRIVE
	int	MSDOS 
	inc	al 			; adjust so A=1
	mov	dl, al
	add	al, 'A'-1
	mov	[tmpfile], al 		; put the drive letter into tmpfile
	lea	si, [tmpfile+3]		; point to path proper
	mov	ah, GET_DIR 		; get current path
	int	MSDOS 
	mov	ah, NEW_FILE		; append a unique file name
	xor	cx, cx
	lea	dx, [tmpfile]
	int	MSDOS
					; Now open the save file...
	lea	dx, [tmpfile]
	mov	cx, 20h 		; file attribute
	mov	ah, CREATE_FL 
	int	MSDOS
	jnb	@@createok
	jmp	@@return
@@createok:				; Now dump memory to the file
	mov	bx, ax 			; load file handle
	mov	di, [@@freereq]
	mov	ax, [paragraphnum] 	; compute base of area to free
	sub	ax, [@@freereq]
	push	ds
	mov	ds, ax 			; init ds:dx to base of area to save
	xor	dx, dx
@@writeloop:
	cmp	di, WRITEBATCH 		; can write all paras in one shot?
	jbe	@@writelast
	sub	di, WRITEBATCH 		; dec paras-to-write count
	mov	cx, WRITEBATCH shl 4
	mov	ah, WRITE_FL 
	int	MSDOS
	jc	@@writeerror
	cmp	ax, cx 			; wrote all bytes?
	je	@@writeok
	mov	ax, 20 			; write count error
	jmp	@@writeerror 
@@writeok:
	mov	ax, ds 			; inc buffer pointer
	add	ax, WRITEBATCH 
	mov	ds, ax 
	jmp	@@writeloop
@@writelast:
	mov	cl, 4 			; shift para count to byte count
	shl	di, cl 
	mov	cx, di 			; put byte count into cx
	mov	ah, WRITE_FL 
	int	MSDOS 			; do it
	jb	@@writeerror 		; branch if error
	cmp	ax, cx 			; wrote all bytes?
	je	@@writedone 
	mov	ax, 20 			; indicate write count error
@@writeerror:
	pop	ds
	push	ax 			; save error code
	mov	ah, CLOSE_FL 
	int	MSDOS 
	call	delete 
	jmp	@@exit
@@writedone:
	pop	ds
	mov	ah, CLOSE_FL 
	int	MSDOS 
	jnb	@@closeok
	jmp	@@return
@@closeok:	      	 		; Free up Scheme's user memory
	mov	es, [first_dos] 	; point es to base of allocated area
	mov	bx, [paragraphnum] 	; compute # paras to remain allocated
	sub	bx, [first_dos]
	sub	bx, [@@freereq]
	mov	ah, MODIFMEM
	int	MSDOS
	jnc	@@memoryok 
	push	ax			; save error code
	call	delete
	jmp	@@exit

@@memoryok:				; Set up parameter block
	mov	dx, [emshandle]
	cmp	dx, 0ffffh		; EMS allocated ?
	je	@@savenoems
	mov	ah, 47h			; save the mapping in case
	int	EMMINT			; the callee clobbers it (Brief ...)
@@savenoems:
	mov	ax, [@@param] 		; Set up dword pointer to command line
	mov	[WORD LOW cmdptr], ax 
	mov	[WORD HIGH cmdptr], ds 
	mov	es, [_psp]
	mov	ax, [es:02ch] 		; copy current environment ptr to parameter area
	mov	[envptr], ax 		

	call	unfixint C		; reset shift-break vector
	call	is_graph_mode C
	or	ax, ax
	jnz	@@shownocursor
	call	zcuron C 		; turn the cursor back on
@@shownocursor:
	push	ds
	pop	es
	mov	dx, [@@file]		; ds:dx is ptr to program
	lea	bx, [paramblk]
	mov	ax, BIDTASK 		; load "load and execute" ftn id
	int	MSDOS
	jc	@@error
	mov	ah, GETRETCODE
	int	MSDOS
	neg	ax			; return negative values for OK
@@error:
	push	ax

	mov	dx, [emshandle]
	cmp	dx, 0ffffh		; EMS allocated ?
	je	@@restorenoems
	mov	ah, 48h			; restore the mapping
	int	EMMINT
@@restorenoems:
	call	is_graph_mode C
	or	ax, ax
	jnz	@@hidenocursor
	call	zcuroff C		; turn the cursor back off
@@hidenocursor:
	call	fix_intr C		; set shift-break vector

	mov	es, [first_dos] 	; point es to base of allocated area
	mov	bx, [paragraphnum] 	; compute # of all available paras
	sub	bx, [first_dos]
	mov	ah, MODIFMEM
	int	MSDOS
	jnc	@@restoremem 
@@fatal:
	pop	ax 			; throw away bid error code
	call	delete 			; delete save file
@@xmsfatal:
	mov	ax, 8000h		; indicate cannot continue, 8000h
	jmp	@@return 
	 
@@restoremem:				; Restore Scheme's user memory
	cmp	[WORD LOW @@xmsaddr], -1
	je	@@restoreswap
	
	lea	si, [@@xmsblock]	; swap source & dest
	mov	ax, [(XMSBLOCK si).dhandle]
	xchg	[(XMSBLOCK si).shandle], ax
	mov	[(XMSBLOCK si).dhandle], ax
	mov	ax, [WORD HIGH (XMSBLOCK si).soff]
	xchg	[WORD HIGH (XMSBLOCK si).doff], ax
	mov	[WORD HIGH (XMSBLOCK si).soff], ax
	mov	ah, 0bh			; move block
	call	[@@xmsaddr]
	or	ax, ax
	jz	@@xmsfatal
	lea	si, [@@xmsblock]
	mov	dx, [(XMSBLOCK si).shandle]
	mov	ah, 0ah
	call	[@@xmsaddr]
	or	ax, ax
	jz	@@xmsfatal
	jmp	@@exit

@@restoreswap:
	lea	dx, [tmpfile]	 	; point ds:dx to ASCIZ save file path
	mov	al, 00 			; access code for reading
	mov	ah, OPEN_FL 
	int	MSDOS
	jc	@@fatal			; abort if cannot open save file
					; Now read memory from the file
	mov	bx, ax 			; load file handle
	mov	di, [@@freereq]
	mov	ax, [paragraphnum] 	; compute base of area to restore from disk
	sub	ax, [@@freereq]
	push	ds
	mov	ds, ax 			; init ds:dx to base of area to restore
	xor	dx, dx 
@@readloop:
	cmp	di, WRITEBATCH 		; can read all paras in one shot?
	jbe	@@readlast
	sub	di, WRITEBATCH
	mov	cx, WRITEBATCH shl 4
	mov	ah, READ_FL 
	int	MSDOS
	jc	@@readerror
	cmp	ax, cx 			; read all bytes?
	jne	@@readerror
	mov	ax, ds 			; inc buffer pointer
	add	ax, WRITEBATCH 
	mov	ds, ax 
	jmp	@@readloop
@@readlast:
	mov	cl, 4 			; shift para count to byte count
	shl	di, cl 
	mov	cx, di 			; put byte count into cx
	mov	ah, READ_FL 
	int	MSDOS
	jc	@@readerror
	cmp	ax, cx 			; read all bytes?
	je	@@readdone
@@readerror:
	pop	ds
	mov	ah, CLOSE_FL 
	int	MSDOS 
	jmp	@@fatal
@@readdone:
	pop	ds
	mov	ah, CLOSE_FL 
	int	MSDOS 
	call	delete
@@exit:
	pop	ax
@@return:
	ret
ENDP	bid_task
	 
	END	
