;* makesolv.s
;************************************************************************
;*									*
;*		PC Scheme/Geneva 4.00 Scheme Demo code			*
;*									*
;* (c) 1985-1988 by Texas Instruments, Inc. See COPYRIGHT.TXT		*
;* (c) 1992 by L. Bartholdi & M. Vuilleumier, University of Geneva	*
;*									*
;*----------------------------------------------------------------------*
;*									*
;*	       Problem solver using a generative grammar		*
;*									*
;*----------------------------------------------------------------------*
;*									*
;* Created by: Marc Vuilleumier		   Date: 1993			*
;* Revision history:							*
;* - 18 Jun 92:	Renaissance (Borland Compilers, ...)			*
;*									*
;*					``In nomine omnipotentii dei''	*
;************************************************************************
; Goal   : generating any non-zero number from a set of numbers and operators
; Sample : Using +, -, *, / and the number 4
;	   1 = 4/4
;	   2 = (4+4)/4
;	   etc...
;
; Usage : (define {solver} (make-solver {list of items} {list of operators}))
;	   ...where each item is ({number} . {representation})
;
; Demo  : [1] (define my-solver (make-solver '((4 . 4)) (list + - * /))
;         ===> MY-SOLVER
;	  [2] (my-solver 1)
;	  ===> (<Procedure /> 4 4)

(define (make-solver items operators . yet)
  (named-lambda (find wanted)
    (set! yet
      (if (car yet) 
	  (list #f (cadr yet) (cadddr yet) (caddr yet))
	  (if (cdadr yet) 
	      (list #t (cdadr yet) (cadddr yet) (caddr yet))
	      (if (not (eq? (car (cadddr yet)) (car (caddr yet))))
		  (list #t operators (cadddr yet) (cdaddr yet))
		  (if (cdr (cadddr yet))
		      (list #t operators (cdr (cadddr yet)) items)
		      (if (null? yet)
			  (list #t operators items items)
			  (error "Sorry, no solution...")))))))
    (or (cdr (assoc wanted items))
	(let ((res (apply (caadr yet) (map caar (cddr yet)))))
	  (if (not (or (zero? res) (assoc res items)))
	      (append! items `((,res . (,(caadr yet) ,@(map cdar (cddr yet)))))))
	  (find wanted)))))
