/* Copyright  1991 Gustavus Adolphus College.  All rights reserved.
 *
 * Schematik was developed by Gustavus Adolphus College (GAC) with
 * support from NeXT Computer, Inc.  Permission to copy this software,
 * to redistribute it, and to use it for any purpose is granted,
 * subject to the following restrictions and understandings.
 *
 * 1. Any copy made of this software must include this copyright
 * notice in full.
 *
 * 2. Users of this software agree to make their best efforts (a) to
 * return to the GAC Mathematics and Computer Science Department any
 * improvements or extensions that they make, so that these may be
 * included in future releases; and (b) to inform GAC of noteworthy
 * uses of this software.
 *
 * 3. All materials developed as a consequence of the use of this
 * software shall duly acknowledge such use, in accordance with the
 * usual standards of acknowledging credit in academic research.
 *
 * 4. GAC makes no express or implied warranty or representation of
 * any kind with respect to this software, including any warranty
 * that the operation of this software will be error-free.  ANY
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR
 * PURPOSE IS HEREBY DISCLAIMED.  GAC is under no obligation to
 * provide any services, by way of maintenance, update, or otherwise.
 *
 * 5. In conjunction with products arising from the use of this
 * material, there shall be no use of the name of Gustavus Adolphus
 * College nor of any adaptation thereof in any advertising,
 * promotional, or sales literature without prior written consent
 * from GAC in each case.
 */

#import <objc/Object.h>

@interface HelpAgent:Object
{
NXZone	*agentZone;
    id	helpPanel;
    id	manualPanel;
    id	helpScrollView;
    id	topicsBrowser;
    id	entryField;
    id	pageBrowser;
}

+ new;

- activateAgent:sender;
- helpBrowserClick:sender;
//- manualBrowserClick:sender;
//- manualBrowserDoubleClick:sender;

- (id)helpScrollView;

@end

#import <appkit/View.h>

@interface ManualView:View
{
   int	numPages;
   int	resolution;
    id	entryIndexList;
}

- displayPage:(unsigned)aPage at:(int)aLocation;
- generateIndex;

@end

@interface ManualEntry:Object
{
  char	*entryName;
  char	*pageLabel;
 short	absPage;
   int	pageStartLine;
 short	xPos;
 short	yPos;
}

- init:(char *)anEntry page:(short)aPage line:(int)aLine label:(char *)aLabel x:(short)x y:(short)y;
- (char *)entry;
- (char *)pageLabel;
- (short)absolutePage;
- (int)pageStartLine;
- (short)xPosition;
- (short)yPosition;

@end
