#| -*-Scheme-*-

Modified July 28, 1991 by Max Hailperin <max@nic.gac.edu>
to use Schematik-style graphics if present, else X if present,
else complain.  (With an easily modified/extended list of device-type
preferences.)  Also fixed an apparent bug in the X window size.
These changes are marked with the comment [max, 7/28/91].

Further modified August 22, 1991 by Max Hailperin <max@nic.gac.edu>
to make graphics-available? check if any of the device types in the
preference list is available instead of (still) just checking X.
This change is marked [max, 8/22/91].

Yet further modified January 12, 1993 by Max Hailperin <max@nic.gac.edu>
by changing all lambda's to named-lambda's so that the debugging info
would show the name of the graphics procedures.

$Header: graphics.scm,v 1.2 90/11/14 14:57:58 GMT cph Exp $

Copyright (c) 1987, 1988, 1989, 1990 Massachusetts Institute of Technology

This material was developed by the Scheme project at the Massachusetts
Institute of Technology, Department of Electrical Engineering and
Computer Science.  Permission to copy this software, to redistribute
it, and to use it for any purpose is granted, subject to the following
restrictions and understandings.

1. Any copy made of this software must include this copyright notice
in full.

2. Users of this software agree to make their best efforts (a) to
return to the MIT Scheme project any improvements or extensions that
they make, so that these may be included in future releases; and (b)
to inform MIT of noteworthy uses of this software.

3. All materials developed as a consequence of the use of this
software shall duly acknowledge such use, in accordance with the usual
standards of acknowledging credit in academic research.

4. MIT has made no warrantee or representation that the operation of
this software will be error-free, and MIT is under no obligation to
provide any services, by way of maintenance, update, or otherwise.

5. In conjunction with products arising from the use of this material,
there shall be no use of the name of the Massachusetts Institute of
Technology nor of any adaptation thereof in any advertising,
promotional, or sales literature without prior written consent from
MIT in each case. |#

;;;; Student graphics Interface
;;;; implemented for X Windows

(declare (usual-integrations))

(define clear-graphics)
(define clear-point)
(define draw-line-to)
(define draw-point)
(define graphics-available?)
(define graphics-text)
(define init-graphics)
(define position-pen)

(define graphics-package
  (make-environment

    (define device-preference-list      ;[max, 7/28/91]
      `((,schematik-style-graphics-device-type pixels 512 390)
        (,x-graphics-device-type #f "512x390" #f))) ;was 512x388, a bug?

    (define graphics-device #F)

    (define (init-if-necessary)
      (if (not graphics-device)
        (init-graphics)))

    (set! clear-graphics
          (named-lambda (clear-graphics)
            (init-if-necessary)
            (graphics-clear graphics-device)
            (graphics-move-cursor graphics-device 0 0)))

    (set! clear-point
          (named-lambda (clear-point x y)
            (init-if-necessary)
            (graphics-erase-point graphics-device x y)))

    (set! draw-line-to
          (named-lambda (draw-line-to x y)
            (init-if-necessary)
            (graphics-drag-cursor graphics-device x y)))

    (set! draw-point
          (named-lambda (draw-point x y)
            (init-if-necessary)
            (graphics-draw-point graphics-device x y)))

    (set! graphics-available?
          (named-lambda (graphics-available?)
            (let loop ((l device-preference-list)) ;[max, 8/22/91]
              (cond ((null? l) #f)
                    ((graphics-type-available? (caar l)) #t)
                    (else (loop (cdr l)))))))

    (set! graphics-text
          (named-lambda (graphics-text text x y)
            (init-if-necessary)
            ;; Accepts different parameters on Chipmunks.
            (graphics-draw-text graphics-device x y text)))

    (set! init-graphics
          (named-lambda (init-graphics)
            (let loop                   ;[max, 7/28/91]
                ((l device-preference-list))
              (cond ((null? l) (error "No graphics available on this machine"))
                    ((graphics-type-available? (caar l))
                     (set! graphics-device
                           (apply make-graphics-device (car l))))
                    (else (loop (cdr l)))))
            (graphics-set-coordinate-limits graphics-device -256 -195 255 194)
            (graphics-move-cursor graphics-device 0 0)))

    (set! position-pen
          (named-lambda (position-pen x y)
            (init-if-necessary)
            (graphics-move-cursor graphics-device x y)))

))