/*
     libscheme	
     Copyright (C) 1994 Brent Benson

     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 1, or (at your option)
     any later version.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "scheme.h"
#include <string.h>

Scheme_Object *scheme_type_type;

void
scheme_init_type (Scheme_Env *env)
{
  scheme_type_type = scheme_make_type ("<type>");
  SCHEME_TYPE (scheme_type_type) = scheme_type_type;
  scheme_add_global ("<type>", scheme_type_type, env);
}

Scheme_Object *
scheme_make_type (char *name)
{
  Scheme_Object *type;

  type = scheme_alloc_object ();
  SCHEME_TYPE(type) = scheme_type_type;
  SCHEME_STR_VAL(type) = scheme_strdup (name);
  return (type);
}
