/*
     libscheme	
     Copyright (C) 1994 Brent Benson

     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 1, or (at your option)
     any later version.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "scheme.h"

main(int argc, char *argv[])
{
  Scheme_Env *global_env;
  Scheme_Object *obj, *in_port;
  int i;
  FILE *fp;

  global_env = scheme_basic_env ();
  GC_expand_hp (200);

  /* load any files given on the command line */
  for ( i=1 ; i<argc ; ++i )
    {
      fp = fopen (argv[i], "r");
      if (! fp)
	{
	  fprintf (stderr, "could not open file for loading: %s\n", argv[i]);
	}
      else
	{
	  in_port = scheme_make_file_input_port (fp);
	  while ((obj = scheme_read (in_port)) != scheme_eof)
	    {
	      obj = SCHEME_CATCH_ERROR (scheme_eval (obj, global_env), 0);
	    }
	  scheme_close_input_port (in_port);
	}
    }
  /* enter read-eval-print loop */
  do
    {
      printf ("> ");
      obj = scheme_read (scheme_stdin_port);
      if (obj == scheme_eof)
	{
	  printf ("\n; done\n");
	  exit (0);
	}
      obj = SCHEME_CATCH_ERROR(scheme_eval (obj, global_env),0);
      if (obj)
	{
	  scheme_write (obj, scheme_stdout_port);
	  printf ("\n");
	}
    }
  while ( 1 );
}
