/* special objects */

#include "fools.h"
#include "utils.h"

#ifndef lint
static char SccsId[] = "@(#)Special.c	1.8 2/23/90";
#endif /* lint */

/* pname is the print name */
Obj newUnique(class, pname)
     Class class;
     char *pname;
{
    Obj new;

    new = gcNew(class);
    objLink(new);
    DATA(new, pname, uniqueInst) = pname;
    return new;
}

static void uniquePrint(uniq, file)
     Obj uniq;
     FILE *file;
{
    fputs(DATA(uniq, pname, uniqueInst), file);
}

#define DEFUNIQUE(type) \
    DEFBASIC(Basic, uniqueInst_t, uniquePrint, (F_VOID)NULL, type)

basicClass_t protoNil = DEFUNIQUE("null");
basicClass_t protoTrue = DEFUNIQUE("true");
basicClass_t protoFalse = DEFUNIQUE("false");
basicClass_t protoEOF = DEFUNIQUE("end-of-file");

/* packages */

Obj TopLevel;
static TreeNode packageTree;

Obj packageByName(name)
     Obj name;
{
    Obj pack;

    if (pack = objGetProp(name, &packageTree))
	return pack;
    pack = newPair(gcNew, name, newFrame(gcNew, GlobalEnv));
    objSetProp(name, pack, &packageTree, FALSE);
    
    return pack;
}

/* initialize package module */
void packageInit()
{
    Obj tp = objIntern("top-level", STATIC);

    TopLevel = newPair(gcNew, tp, GlobalEnv);
    objSetProp(tp, TopLevel, &packageTree, FALSE);
}

Obj newPackage(pspec)
     char *pspec;
{
    char *ptr;
    Obj new;

    /* separate symbol from package name */
    for (ptr = pspec; *ptr != ':'; ptr++);
    *ptr++ = '\0';

    if (*pspec == '\0' && *ptr == '\0')
	new = objIntern(":", STATIC);
    else {
	new = gcNew(Package);
	DATA(new, sym, packageInst) = objIntern(ptr, 0);
	DATA(new, package, packageInst) =
	    (*pspec == '\0' ? TopLevel : packageByName(objIntern(pspec, 0)));
    }
    ptr[-1] = ':'; /* put ':' back */
    return new;
}

static void packagePrint(pkg, file)
     Obj pkg;
     FILE *file;
{
    (void)objfPrintf(file, "%O:%O",
		     objCar(DATA(pkg, package, packageInst)),
		     DATA(pkg, sym, packageInst));
}

basicClass_t protoPackage =
    DEFBASIC(Basic, packageInst_t, packagePrint, (F_VOID)NULL,
	     "packaged-symbol");

	/* boxes */

/* make a new box (pointer type) */
Obj newBox(alloc, ref)
     F_OBJ alloc;
     Obj ref;
{
    Obj new;

    new = (*alloc)(Box);
    if (DATA(new, ref, boxInst) = ref)
	objLink(ref);
    return new;
}

/* make box a reference to ref */
void objBoxSet(box, ref)
     Obj box, ref;
{
    Obj prev;

    if (ref) objLink(ref);
    if (prev = DATA(box, ref, boxInst))
	objUnlink(prev);
    DATA(box, ref, boxInst) = ref;
}

/* printer */

static void boxPrint1(box, fp)
     Obj box;
     FILE *fp;
{
    if (checkCond(box, MARK))
	fputs("...", fp);
    else {
	Obj ref = DATA(box, ref, boxInst);

	setCond(box, MARK);
	if (checkCond(ref, MARK))
	    fputs("#&...", fp);
	else objfPrintf(fp, "#&%O", ref);
    }
}

static void boxPrint(box, fp)
     Obj box;
     FILE *fp;
{
    Callback_t cb;

    cb.arg = (Ptr)box;
    cb.func = clearMarks;
    errorPushCB(&cb);
    boxPrint1(box, fp);
    errorPopCB();
    clearMarks(box);
}

/* destructor */
static void boxDestroy(box)
     Obj box;
{
    Obj ref = DATA(box, ref, boxInst);

    if (ref) objUnlink(ref);
}

basicClass_t protoBox =
    DEFBASIC(Basic, boxInst_t, boxPrint, boxDestroy, "box");
