/* misc.c - misc routines used by elk extensions
 */

#include <theusual.h>

/*** common data ***/
Efloat Cflt0 = 0.0;
Efloat Cflt05 = 0.5;
Efloat Cflt1 = 1.0;
Efloat Cflt2 = 2.0;
Efloat CfltPI = 3.1415926535897932384626433832795028841972;
Efloat Cflt2PI = 6.2831853071795864769252867665590057683944;
Efloat CfltPIo2 = 1.5707963267948966192313216916397514420986;
char Ctmpbuf[512];
int Ctmpbuflen = 512;


/* return a printable representation of the date, in no particular format.
 * arg is a date/type represented as a unsigned long; 
 */
#if Emac
char *Ztimestring
Ztimestring(idate)
  Ztime_t idate;
{
  static char str[40];
  iudatestring(idate,0,str);
  return str;
} /*timestring*/
#endif


#if Eunix
char *Ztimestring(itime)
  Ztime_t itime;
{
  extern char *ctime();
  char *c,*cp;
  Ztrace(("timestring(%d)\n",itime));

  c = ctime(&itime);

  /* ctime returns a string which ends with \n. dont like this. */
  for( cp=c; *cp; cp++ ) {
    if (*cp == '\n') {
      *cp = (char)0;
      if (*(cp+1) != (char)0) Zcodeerror("timestring");
    }
  }

  return (c);
} /*timestring*/
#endif



/* return a represenatation of the date/time as unsigned long seconds */
#if Emac
Ztime_t Zcurtime()
{
  unsigned int4 i;
  GetDateTime(&i);
  return((Ztime_t)i);
} /*Zcurtime*/
#endif

#if Eunix
Ztime_t Zcurtime()
{

  return ((Ztime_t)time(NULL));
}
#endif



char *str_end(cp)
  register char *cp;
{
  while (*cp) cp++;
  return (cp);
}


int /*bool*/ str_any(c, cc)
  register char *c,*cc;
{
  register char *s;
  while(*c) {
    s = cc;
    while (*s)
      if (*s++ == *c)
        return(TRUE);
    c++;
  }
  return(FALSE);
} /*any*/


char *Zsalloc(str)
  char *str;
{
  char *s;
  s = (char *)malloc(strlen(str)+1);
  strcpy(s,str);
  return(s);
}
