/* fail.c zilla 23aug - C version: error & abort. lisp version: error throw
 * keep in a separate file so programs can use routines in libz but
 * define their own Zcodeerror.
 * mod
 * 28apr        bugfix 
 * 15oct        rname to Zfail
 */

#include <theusual.h>

#if Evarargs
# include <varargs.h>
#endif
#if Estdarg
# include <stdarg.h>
#endif

#if (Estdarg&&Evprintf)
#define _fail_def_
proc Zfail(char *msg,...)
{
    va_list ap;
    
    fflush(stdout);
    fprintf(stderr,"FAILING: ");
    va_start(ap,msg);
    vfprintf(stderr,msg,ap);
    putc('\n',stderr);
    va_end(ap);
    abort();
}
#endif

#if (Evarargs&&Evprintf)
#define _fail_def_
proc Zfail(va_alist)
 va_dcl
{
    va_list ap;
    char *msg;
    
    fflush(stdout);
    va_start(ap);
    msg = va_arg(ap,char *);
    fprintf(stderr,"FAILING: ");
    vfprintf(stderr,msg,ap);
    putc('\n',stderr);
    va_end(ap);
    abort();
}
#endif

#ifndef _fail_def_
proc Zfail(msg)
  char *msg;
{
    fflush(stdout);
	fprintf(stderr,"fail: %s\n",msg);
    abort();
}
#endif
#undef _fail_def_
