;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/ml/camloo/runtime0.0/Llib/bmisc.scm ...                  */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Dec 13 16:27:48 1993                          */
;*    Last change :  Mon Mar 14 08:56:48 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Tous les trucs un peu divers que je ne savais pas trop ou        */
;*    mettre                                                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __caml_bmisc
   (foreign (int c-init_camloo!    ()              "init_camloo")
	    (obj get_next_char   (obj)             "get_next_char")
	    (obj parse_engine    (obj obj obj obj) "parse_engine")
	    (obj hash_univ_param (obj obj obj)     "hash_univ_param"))
   (import  (__caml_handle "Llib/handle.scm"))
   (export  (init_camloo!)
	    (inline tree_equal s1 s2)))

;*---------------------------------------------------------------------*/
;*    init_camloo! ...                                                 */
;*---------------------------------------------------------------------*/
(define (init_camloo!)
   (if (eq? #t #f)
       ;; un hack pour etre sur que le module `__error' est initialise
       (the_failure "init_camloo" "installing" "error-handling")
       (begin
	  (set! current_handler #f)
	  (c-init_camloo!))))

;*---------------------------------------------------------------------*/
;*    tree_equal ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (tree_equal s1 s2)
   (equal? s1 s2))

 
