/*---------------------------------------------------------------------*/
/*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \    /  '                              */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome Send them to                                           */
/*        <Manuel.Serrano@inria.fr>                                    */
/*        Manuel Serrano                                               */
/*        INRIA -- Rocquencourt                                        */
/*        Domaine de Voluceau, BP 105                                  */
/*        78153 Le Chesnay Cedex                                       */
/*        France                                                       */
/*---------------------------------------------------------------------*/


/*=====================================================================*/
/*    serrano/ml/camloo/runtime0.0/Clib/fail.c ...                     */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Fri Dec 17 14:26:44 1993                          */
/*    Last change :  Thu Jan 13 10:24:12 1994 (serrano)                */
/*    -------------------------------------------------------------    */
/*    Ma version du fichier `fail.c'                                   */
/*=====================================================================*/
#include <bigloo.h>
#include <caml-bigloo.h>
#include <value-bigloo.h>
#include "../CAMLClib/fail.h"

/*---------------------------------------------------------------------*/
/*    Les recuperations externes                                       */
/*---------------------------------------------------------------------*/
extern obj_t caml_make_extensible();
extern obj_t raise();

#define raise RAISE___CAML_HANDLE_218

/*---------------------------------------------------------------------*/
/*    void                                                             */
/*    mlraise ...                                                      */
/*---------------------------------------------------------------------*/
void
mlraise( v )
value v;
{
	if( CAML_EXTENSIBLE_CONSTRP( v ) || SYMBOLP( v ) )
	   raise( v );
	else
	   if( CNSTP( v ) )
	      switch( CCNST( v ) - 1 )
		   {
			   case( OUT_OF_MEMORY_EXN ) :
				   raise( c_string_to_symbol( "OUT_OF_MEMORY@EXC" ) );
				   break;
   
			   case( END_OF_FILE_EXN ) :
				   raise( c_string_to_symbol( "END_OF_FILE@IO" ) );
				   break;

			   case( UNIX_ERROR_EXN ) :
				   raise( c_string_to_symbol( "UNIX_ERROR" ) );
					break;

			   default :
			      raise( c_string_to_symbol( "UNKNOWN_EXCEPTION" ) );
				   break;
		   }
	   else
		   raise( c_string_to_symbol( "UNKNOWN_EXCEPTION" ) );
}

/*---------------------------------------------------------------------*/
/*    void                                                             */
/*    raise_with_arg ...                                               */
/*---------------------------------------------------------------------*/
void
raise_with_arg( tag, arg )
tag_t tag;
value arg;
{
	obj_t new_tag;

	switch( tag )
	{
      case( OUT_OF_MEMORY_EXN ) :
 		   new_tag = c_string_to_symbol( "OUT_OF_MEMORY@EXC" );
			break;

	   case( SYS_ERROR_EXN ) :
		   new_tag = c_string_to_symbol( "SYS_ERROR@SYS" );
			break;

      case( FAILURE_EXN ) : 
         new_tag = c_string_to_symbol( "FAILURE@EXC" );
			break;

      case( INVALID_EXN ) : 
         new_tag = c_string_to_symbol( "INVALID_ARGUMENT@EXC" );
			break;
			
      case( END_OF_FILE_EXN ) : 
         new_tag = c_string_to_symbol( "END_OF_FILE@IO" );
			break;
			
      case( ZERO_DIVIDE_EXN ) : 
         new_tag = c_string_to_symbol( "DIVISION_BY_ZERO@EXC" );
			break;
			
      case( BREAK_EXN ) : 
         new_tag = c_string_to_symbol( "BREAK@SYS" );
			break;
			
      case( NOT_FOUND_EXN ) : 
         new_tag = c_string_to_symbol( "NOT_FOUND@EXC" );
			break;
			
      case( UNIX_ERROR_EXN ) : 
         new_tag = c_string_to_symbol( "UNIX_ERROR" );
			break;
			
      case( GRAPHIC_FAILURE_EXN ) : 
         new_tag = c_string_to_symbol( "GRAPHIC_FAILURE" );
			break;
			
      case( PARSE_FAILURE_EXN ) : 
         new_tag = c_string_to_symbol( "PARSE_FAILURE@STREAM" );
			break;
			
	   default:
			new_tag = c_string_to_symbol( "UNKNOWN_EXCEPTION" );
	}
	
	mlraise( caml_make_extensible( new_tag, BINT( 1 ), arg ) );
}

/*---------------------------------------------------------------------*/
/*    void                                                             */
/*    raise_with_string ...                                            */
/*---------------------------------------------------------------------*/
void
raise_with_string( tag, msg )
tag_t  tag;
char  *msg;
{
	raise_with_arg( tag, c_string_to_string( msg ) );
}

/*---------------------------------------------------------------------*/
/*    void                                                             */
/*    failwith ...                                                     */
/*---------------------------------------------------------------------*/
void
failwith( msg )
char *msg;
{
	raise_with_string( INVALID_EXN, msg );
}
			
/*---------------------------------------------------------------------*/
/*    void                                                             */
/*    invalid_argument ...                                             */
/*---------------------------------------------------------------------*/
void
invalid_argument( msg )
char *msg;
{
  raise_with_string( INVALID_EXN, msg );
}

/*---------------------------------------------------------------------*/
/*    void                                                             */
/*    raise_out_of_memory ...                                          */
/*---------------------------------------------------------------------*/
void
raise_out_of_memory()
{
  mlraise( Atom( OUT_OF_MEMORY_EXN ) );
}

