;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;; Le module                                                                 
(module
  __caml_string
  (foreign (include #"caml-bigloo.h"))
  (import)
  (export
    (create_string_138@string x1)
    (make_string_7@string x1)
    (2-69-make_string_7@string x1 x2)
    (nth_char_166@string x1)
    (2-143-nth_char_166@string x1 x2)
    (set_nth_char_28@string x1)
    (3-179-set_nth_char_28@string x1 x2 x3)
    (fill_string_42@string x1)
    (4-232-fill_string_42@string x1 x2 x3 x4)
    (blit_string_211@string x1)
    (5-22-blit_string_211@string x1 x2 x3 x4 x5)
    ^_54@string
    (sub_string_61@string x1)
    (3-23-sub_string_61@string x1 x2 x3)
    (replace_string_174@string x1)
    (3-75-replace_string_174@string x1 x2 x3)
    string_for_read_244@string))
;; L'initialisation du module                                                
(init_camloo!)
;; Les variables globales                                                    
;; Les expressions globales                                                  
(define create_string_138@string
  (lambda (x1)
    (if (or (<fx x1 0) (>=fx x1 (bit-lsh 1 28)))
      (invalid_arg_209@exc #"create_string")
      (c-create_string x1))))

(begin
  (define make_string_7@string
    (lambda (x1)
      (lambda (x2) (2-69-make_string_7@string x1 x2))))
 (define 2-69-make_string_7@string
    (lambda (x1 x2)
      (if (or (<fx x1 0) (>=fx x1 (bit-lsh 1 28)))
        (invalid_arg_209@exc #"make_string")
        ((make_string_7@fstring x1) x2))))
)
(begin
  (define nth_char_166@string
    (lambda (x1)
      (lambda (x2) (2-143-nth_char_166@string x1 x2))))
 (define 2-143-nth_char_166@string
    (lambda (x1 x2)
      (if (or (<fx x2 0) (>=fx x2 (string-length x1)))
        (invalid_arg_209@exc #"nth_char")
        (string-ref x1 x2))))
)
(begin
  (define set_nth_char_28@string
    (lambda (x1)
      (lambda (x2)
        (lambda (x3)
          (3-179-set_nth_char_28@string x1 x2 x3)))))
 (define 3-179-set_nth_char_28@string
    (lambda (x1 x2 x3)
      (if (or (<fx x2 0) (>=fx x2 (string-length x1)))
        (invalid_arg_209@exc #"set_nth_char")
        (string-set! x1 x2 x3))))
)
(begin
  (define fill_string_42@string
    (lambda (x1)
      (lambda (x2)
        (lambda (x3)
          (lambda (x4)
            (4-232-fill_string_42@string x1 x2 x3 x4))))))
 (define 4-232-fill_string_42@string
    (lambda (x1 x2 x3 x4)
      (if (or (<fx x2 0)
              (or (<fx x3 0)
                  (>fx (+fx x2 x3) (string-length x1))))
        (invalid_arg_209@exc #"fill_string")
        (c-fill_string x1 x2 x3 x4))))
)
(begin
  (define blit_string_211@string
    (lambda (x1)
      (lambda (x2)
        (lambda (x3)
          (lambda (x4)
            (lambda (x5)
              (5-22-blit_string_211@string x1 x2 x3 x4 x5)))))))
 (define 5-22-blit_string_211@string
    (lambda (x1 x2 x3 x4 x5)
      (if (or (<fx x2 0)
              (or (>fx (+fx x2 x5) (string-length x1))
                  (or (<fx x4 0)
                      (or (>fx (+fx x4 x5) (string-length x3))
                          (<fx x5 0)))))
        (invalid_arg_209@exc #"blit_string")
        (c-blit_string x1 x2 x3 x4 x5))))
)
(define ^_54@string ^_54@fstring)
(begin
  (define sub_string_61@string
    (lambda (x1)
      (lambda (x2)
        (lambda (x3)
          (3-23-sub_string_61@string x1 x2 x3)))))
 (define 3-23-sub_string_61@string
    (lambda (x1 x2 x3)
      (if (or (<fx x2 0)
              (or (<fx x3 0)
                  (>fx (+fx x2 x3) (string-length x1))))
        (invalid_arg_209@exc #"sub_string")
        (((sub_string_61@fstring x1) x2) x3))))
)
(begin
  (define replace_string_174@string
    (lambda (x1)
      (lambda (x2)
        (lambda (x3)
          (3-75-replace_string_174@string x1 x2 x3)))))
 (define 3-75-replace_string_174@string
    (lambda (x1 x2 x3)
      (if (or (<fx x3 0)
              (>fx (+fx x3 (string-length x2))
                   (string-length x1)))
        (invalid_arg_209@exc #"replace_string")
        (((replace_string_174@fstring x1) x2) x3))))
)
(define string_for_read_244@string
  string_for_read_244@fstring)

(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
