;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;; Le module                                                                 
(module
  __caml_fvect
  (foreign (include #"caml-bigloo.h"))
  (import)
  (export
    (make_matrix_88@fvect x1)
    (3-21-make_matrix_88@fvect x1 x2 x3)
    (blit_vect_203@fvect x1)
    (5-48-blit_vect_203@fvect x1 x2 x3 x4 x5)
    (fill_vect_126@fvect x1)
    (4-206-fill_vect_126@fvect x1 x2 x3 x4)
    (copy_vect_177@fvect x1)
    (concat_vect_32@fvect x1)
    (2-164-concat_vect_32@fvect x1 x2)
    (sub_vect_160@fvect x1)
    (3-89-sub_vect_160@fvect x1 x2 x3)
    (list_of_vect_3@fvect x1)
    (vect_of_list_150@fvect x1)
    (do_vect_153@fvect x1)
    (2-211-do_vect_153@fvect x1 x2)
    (map_vect_149@fvect x1)
    (2-233-map_vect_149@fvect x1 x2)
    (map_vect_list_65@fvect x1)
    (2-221-map_vect_list_65@fvect x1 x2)))
;; L'initialisation du module                                                
(init_camloo!)
;; Les variables globales                                                    
;; Les expressions globales                                                  
(begin
  (define make_matrix_88@fvect
    (lambda (x1)
      (lambda (x2)
        (lambda (x3)
          (3-21-make_matrix_88@fvect x1 x2 x3)))))
 (define 3-21-make_matrix_88@fvect
    (lambda (x1 x2 x3)
      (let ((x4 (make-vector x1 (caml-make-tag 0 0))))
        (begin
          (let ((:-d.stop1002 (-fx x1 1)))
            (let :-d.for1001 ((i5 0))
              (if (<=fx i5 :-d.stop1002)
                (begin
                  (vector-set! x4 i5 (make-vector x2 x3))
                  (:-d.for1001 (+fx i5 1)))
                (unspecified))))
          x4))))
)
(begin
  (define blit_vect_203@fvect
    (lambda (x1)
      (lambda (x2)
        (lambda (x3)
          (lambda (x4)
            (lambda (x5)
              (5-48-blit_vect_203@fvect x1 x2 x3 x4 x5)))))))
 (define 5-48-blit_vect_203@fvect
    (lambda (x1 x2 x3 x4 x5)
      (if (<fx x2 x4)
        (let ((:-d.stop1006 0))
          (let :-d.for1005 ((i6 (-fx x5 1)))
            (if (>=fx i6 :-d.stop1006)
              (begin
                (vector-set!
                  x3
                  (+fx x4 i6)
                  (vector-ref x1 (+fx x2 i6)))
                (:-d.for1005 (-fx i6 1)))
              (unspecified))))
        (let ((:-d.stop1004 (-fx x5 1)))
          (let :-d.for1003 ((i6 0))
            (if (<=fx i6 :-d.stop1004)
              (begin
                (vector-set!
                  x3
                  (+fx x4 i6)
                  (vector-ref x1 (+fx x2 i6)))
                (:-d.for1003 (+fx i6 1)))
              (unspecified)))))))
)
(begin
  (define fill_vect_126@fvect
    (lambda (x1)
      (lambda (x2)
        (lambda (x3)
          (lambda (x4)
            (4-206-fill_vect_126@fvect x1 x2 x3 x4))))))
 (define 4-206-fill_vect_126@fvect
    (lambda (x1 x2 x3 x4)
      (let ((:-d.stop1008 (-fx (+fx x2 x3) 1)))
        (let :-d.for1007 ((i5 x2))
          (if (<=fx i5 :-d.stop1008)
            (begin
              (vector-set! x1 i5 x4)
              (:-d.for1007 (+fx i5 1)))
            (unspecified))))))
)
(define copy_vect_177@fvect
  (lambda (x1)
    (if (eq? (let ((:-d.1011 x1))
               (if :-d.1011 (vector-length :-d.1011) 0))
             0)
      x1
      (let ((x2 (make-vector
                  (let ((:-d.1009 x1))
                    (if :-d.1009 (vector-length :-d.1009) 0))
                  (vector-ref x1 0))))
        (begin
          (((((blit_vect_203@fvect x1) 1) x2) 1)
           (-fx (let ((:-d.1010 x1))
                  (if :-d.1010 (vector-length :-d.1010) 0))
                1))
          x2)))))

(begin
  (define concat_vect_32@fvect
    (lambda (x1)
      (lambda (x2) (2-164-concat_vect_32@fvect x1 x2))))
 (define 2-164-concat_vect_32@fvect
    (lambda (x1 x2)
      (if (eq? (let ((:-d.1018 x1))
                 (if :-d.1018 (vector-length :-d.1018) 0))
               0)
        (copy_vect_177@fvect x2)
        (if (eq? (let ((:-d.1017 x2))
                   (if :-d.1017 (vector-length :-d.1017) 0))
                 0)
          (copy_vect_177@fvect x1)
          (let ((x3 (make-vector
                      (+fx (let ((:-d.1013 x1))
                             (if :-d.1013 (vector-length :-d.1013) 0))
                           (let ((:-d.1012 x2))
                             (if :-d.1012 (vector-length :-d.1012) 0)))
                      (vector-ref x1 0))))
            (begin
              (((((blit_vect_203@fvect x1) 1) x3) 1)
               (-fx (let ((:-d.1016 x1))
                      (if :-d.1016 (vector-length :-d.1016) 0))
                    1))
              (begin
                (((((blit_vect_203@fvect x2) 0) x3)
                  (let ((:-d.1014 x1))
                    (if :-d.1014 (vector-length :-d.1014) 0)))
                 (let ((:-d.1015 x2))
                   (if :-d.1015 (vector-length :-d.1015) 0)))
                x3)))))))
)
(begin
  (define sub_vect_160@fvect
    (lambda (x1)
      (lambda (x2)
        (lambda (x3) (3-89-sub_vect_160@fvect x1 x2 x3)))))
 (define 3-89-sub_vect_160@fvect
    (lambda (x1 x2 x3)
      (if (eq? x3 0)
        (caml-make-tag 0 0)
        (let ((x4 (make-vector x3 (vector-ref x1 x2))))
          (begin
            (let ((:-d.stop1020 (-fx x3 1)))
              (let :-d.for1019 ((i5 1))
                (if (<=fx i5 :-d.stop1020)
                  (begin
                    (vector-set! x4 i5 (vector-ref x1 (+fx x2 i5)))
                    (:-d.for1019 (+fx i5 1)))
                  (unspecified))))
            x4)))))
)
(define list_of_vect_3@fvect
  (lambda (x1)
    (letrec ((x2 (lambda (x3)
                   (if (>=fx x3
                             (let ((:-d.1021 x1))
                               (if :-d.1021 (vector-length :-d.1021) 0)))
                     '()
                     (cons (vector-ref x1 x3) (x2 (+fx x3 1)))))))
      (x2 0))))

(define vect_of_list_150@fvect
  (lambda (x1)
    (if (null? x1)
      (caml-make-tag 0 0)
      (let ((x2 (make-vector (list_length_112@list x1) (car x1))))
        (letrec ((x3 (lambda (x4)
                       (lambda (x5)
                         (if (null? x5)
                           (caml-make-tag 0 1)
                           (begin
                             (vector-set! x2 x4 (car x5))
                             ((x3 (+fx x4 1)) (cdr x5))))))))
          (begin ((x3 1) (cdr x1)) x2))))))

(begin
  (define do_vect_153@fvect
    (lambda (x1)
      (lambda (x2) (2-211-do_vect_153@fvect x1 x2))))
 (define 2-211-do_vect_153@fvect
    (lambda (x1 x2)
      (let ((:-d.stop1023
              (-fx (let ((:-d.1024 x2))
                     (if :-d.1024 (vector-length :-d.1024) 0))
                   1)))
        (let :-d.for1022 ((i3 0))
          (if (<=fx i3 :-d.stop1023)
            (begin
              (x1 (vector-ref x2 i3))
              (:-d.for1022 (+fx i3 1)))
            (unspecified))))))
)
(begin
  (define map_vect_149@fvect
    (lambda (x1)
      (lambda (x2) (2-233-map_vect_149@fvect x1 x2))))
 (define 2-233-map_vect_149@fvect
    (lambda (x1 x2)
      (if (eq? (let ((:-d.1029 x2))
                 (if :-d.1029 (vector-length :-d.1029) 0))
               0)
        (caml-make-tag 0 0)
        (let ((x3 (make-vector
                    (let ((:-d.1025 x2))
                      (if :-d.1025 (vector-length :-d.1025) 0))
                    (x1 (vector-ref x2 0)))))
          (begin
            (let ((:-d.stop1027
                    (-fx (let ((:-d.1028 x2))
                           (if :-d.1028 (vector-length :-d.1028) 0))
                         1)))
              (let :-d.for1026 ((i4 1))
                (if (<=fx i4 :-d.stop1027)
                  (begin
                    (vector-set! x3 i4 (x1 (vector-ref x2 i4)))
                    (:-d.for1026 (+fx i4 1)))
                  (unspecified))))
            x3)))))
)
(begin
  (define map_vect_list_65@fvect
    (lambda (x1)
      (lambda (x2)
        (2-221-map_vect_list_65@fvect x1 x2))))
 (define 2-221-map_vect_list_65@fvect
    (lambda (x1 x2)
      (letrec ((x3 (lambda (x4)
                     (if (>=fx x4
                               (let ((:-d.1030 x2))
                                 (if :-d.1030 (vector-length :-d.1030) 0)))
                       '()
                       (cons (x1 (vector-ref x2 x4)) (x3 (+fx x4 1)))))))
        (x3 0))))
)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
(unspecified)
