;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/ml/camloo/comptime0.0/init.scm ...                       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Dec  1 08:58:21 1993                          */
;*    Last change :  Tue Jan 11 16:45:40 1994 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Les initialisation et terminaisons                               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module init
   (import tools_file
	   module)
   (export (parse-args! argv)
	   (start-io!)
	   (close-io!)
	   (read-afile!)
	   *trace*
	   *pout*
	   *pin*
	   *module*
	   *module-name*
	   *module-alist*))

;*---------------------------------------------------------------------*/
;*    Quelques variables globales de controles                         */
;*---------------------------------------------------------------------*/
(define *trace*         0)
(define *out*           #f)
(define *in*            #f)
(define *pout*          (current-output-port))
(define *pin*           (current-input-port))
(define *module-name*   "foo")
(define *module*        (string->symbol *module-name*))
(define *afile*         #f)
(define *module-alist* '())

;*---------------------------------------------------------------------*/
;*    usage ...                                                        */
;*---------------------------------------------------------------------*/
(define (usage)
   (print "usage: camloo [-afile a-file] [-t<level>] [-o output-file] [-m module-name] [file]")
   (exit -1))
	   
;*---------------------------------------------------------------------*/
;*    parse-args! ...                                                  */
;*---------------------------------------------------------------------*/
(define (parse-args! argv)
   (let loop ((argv argv))
      (cond
	 ((null? argv)
	  'done)
	 ((string=? (car argv) "-help")
	  (usage))
	 ((string=? (car argv) "-afile")
	  (if (null? (cdr argv))
	      (usage)
	      (begin
		 (set! *afile* (cadr argv))
		 (loop (cddr argv)))))
	 ((string=? (car argv) "-o")
	  (if (null? (cdr argv))
	      (usage)
	      (begin
		 (set! *out* (cadr argv))
		 (loop (cddr argv)))))
	 ((string=? (substring (car argv) 0 2) "-t")
	  (set! *trace* (string->integer 
			 (substring (car argv) 2 (string-length (car argv)))))
	  (loop (cdr argv)))
	 ((string=? (car argv) "-m")
	  (if (null? (cdr argv))
	      (usage)
	      (begin
		 (set! *module-name* (cadr argv))
		 (set! *module* (string->symbol *module-name*))
		 (loop (cddr argv)))))
	 (else
	  (set! *in* (car argv))
	  (set! *module-name* (basename (remove-extansion  *in*)))
	  (set! *module* (string->symbol *module-name*))
	  (loop (cdr argv))))))

;*---------------------------------------------------------------------*/
;*    start-io! ...                                                    */
;*---------------------------------------------------------------------*/
(define (start-io!)
   (if (string? *in*)
       (set! *pin* (open-input-file *in*)))
   (if (not (input-port? *pin*))
       (error "start-io!" "Can't open file" *in*))
   (if (string? *out*)
       (set! *pout* (open-output-file *out*)))
   (if (not (output-port? *pout*))
       (error "start-io!" "Can't open file" *out*)))

;*---------------------------------------------------------------------*/
;*    close-io! ...                                                    */
;*---------------------------------------------------------------------*/
(define (close-io!)
   (if (and (string? *in*) (input-port? *pin*))
       (close-input-port *pin*))
   (if (and (string? *out*) (output-port? *pout*))
       (close-output-port *pout*)))

;*---------------------------------------------------------------------*/
;*    read-afile! ...                                                  */
;*---------------------------------------------------------------------*/
(define (read-afile!)
   (cond
      ((not (string? *afile*))
       'done)
      ((not (file-exists? *afile*))
       (error "camloo" "can't find `a file'" *afile*))
      (else
       (let ((port (open-input-file *afile*)))
	  (if (not (input-port? port))
	      (error "camloo" "can't open `a file'" *afile*)
	      (begin
		 (set! *module-alist* (read port))
		 (close-input-port port)
		 'done))))))
