;*---------------------------------------------------------------------*/
;*    Copyright (c) 1994 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.6/Rgc/trap.scm ...          */
;*                                                                     */
;*    Auteur      :  Manuel SERRANO                                    */
;*    Creation    :  Fri Jun 21 10:23:39 1991                          */
;*    Last change :  Thu Nov 25 17:05:13 1993 (serrano)                */
;*                                                                     */
;*    La generation des traps                                          */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*     Le module                                                       */
;*---------------------------------------------------------------------*/
(module __rgc_trap
   (export (pre-trap  t-trap)
	   (trapped?  num)
	   (test-trap num)))

;*---------------------------------------------------------------------*/
;*     Les variables statics                                           */
;*---------------------------------------------------------------------*/
(define *local-trap* #f)

;*---------------------------------------------------------------------*/
;*     pre-trap ...                                                    */
;*---------------------------------------------------------------------*/
(define (pre-trap t-trap)
   (set! *local-trap* t-trap))

;*---------------------------------------------------------------------*/
;*     trapped? ...                                                    */
;*---------------------------------------------------------------------*/
(define (trapped? num)
   (not (null? (vector-ref *local-trap* num))))

;*---------------------------------------------------------------------*/
;*     test-trap ...                                                   */
;*---------------------------------------------------------------------*/
(define (test-trap num)
   (case (vector-ref *local-trap* num)
      ((eof) '(input-port-eof? input-port))
      ((eol) '(input-port-eol? input-port))
      ((bol) '(input-port-bol? input-port))
      (else  `(eq? current-context
		   ',(cadr (vector-ref *local-trap* num))))))
